/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<AttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField
            .<AttachmentsConfiguration> builder(MarshallingType.SDK_POJO).memberName("attachmentsConfiguration")
            .getter(getter(UpdateApplicationRequest::attachmentsConfiguration)).setter(setter(Builder::attachmentsConfiguration))
            .constructor(AttachmentsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateApplicationRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateApplicationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ATTACHMENTS_CONFIGURATION_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ROLE_ARN_FIELD));

    private final String applicationId;

    private final AttachmentsConfiguration attachmentsConfiguration;

    private final String description;

    private final String displayName;

    private final String roleArn;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application.
     * </p>
     * 
     * @return The identifier of the Amazon Q application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * An option to allow end users to upload files directly during chat.
     * </p>
     * 
     * @return An option to allow end users to upload files directly during chat.
     */
    public final AttachmentsConfiguration attachmentsConfiguration() {
        return attachmentsConfiguration;
    }

    /**
     * <p>
     * A description for the Amazon Q application.
     * </p>
     * 
     * @return A description for the Amazon Q application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name for the Amazon Q application.
     * </p>
     * 
     * @return A name for the Amazon Q application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q permission to access Amazon
     * CloudWatch logs and metrics.
     * </p>
     * 
     * @return An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q permission to access
     *         Amazon CloudWatch logs and metrics.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(attachmentsConfiguration(), other.attachmentsConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationId", applicationId())
                .add("AttachmentsConfiguration", attachmentsConfiguration()).add("Description", description())
                .add("DisplayName", displayName()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "attachmentsConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentsConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * 
         * @param attachmentsConfiguration
         *        An option to allow end users to upload files directly during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachmentsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AttachmentsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentsConfiguration(AttachmentsConfiguration)}.
         * 
         * @param attachmentsConfiguration
         *        a consumer that will call methods on {@link AttachmentsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsConfiguration(AttachmentsConfiguration)
         */
        default Builder attachmentsConfiguration(Consumer<AttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return attachmentsConfiguration(AttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration).build());
        }

        /**
         * <p>
         * A description for the Amazon Q application.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the Amazon Q application.
         * </p>
         * 
         * @param displayName
         *        A name for the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q permission to access
         * Amazon CloudWatch logs and metrics.
         * </p>
         * 
         * @param roleArn
         *        An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q permission to
         *        access Amazon CloudWatch logs and metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private AttachmentsConfiguration attachmentsConfiguration;

        private String description;

        private String displayName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            attachmentsConfiguration(model.attachmentsConfiguration);
            description(model.description);
            displayName(model.displayName);
            roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final AttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return attachmentsConfiguration != null ? attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
