/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceSamplePromptsControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebExperienceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::applicationId)).setter(CreateWebExperienceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::clientToken)).setter(CreateWebExperienceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::roleArn)).setter(CreateWebExperienceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samplePromptsControlMode").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::samplePromptsControlModeAsString)).setter(CreateWebExperienceRequest.setter(Builder::samplePromptsControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build()}).build();
    private static final SdkField<String> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtitle").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::subtitle)).setter(CreateWebExperienceRequest.setter(Builder::subtitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::tags)).setter(CreateWebExperienceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::title)).setter(CreateWebExperienceRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("welcomeMessage").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::welcomeMessage)).setter(CreateWebExperienceRequest.setter(Builder::welcomeMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CLIENT_TOKEN_FIELD, ROLE_ARN_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, SUBTITLE_FIELD, TAGS_FIELD, TITLE_FIELD, WELCOME_MESSAGE_FIELD));
    private final String applicationId;
    private final String clientToken;
    private final String roleArn;
    private final String samplePromptsControlMode;
    private final String subtitle;
    private final List<Tag> tags;
    private final String title;
    private final String welcomeMessage;

    private CreateWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.roleArn = builder.roleArn;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.subtitle = builder.subtitle;
        this.tags = builder.tags;
        this.title = builder.title;
        this.welcomeMessage = builder.welcomeMessage;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(this.samplePromptsControlMode);
    }

    public final String samplePromptsControlModeAsString() {
        return this.samplePromptsControlMode;
    }

    public final String subtitle() {
        return this.subtitle;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String title() {
        return this.title;
    }

    public final String welcomeMessage() {
        return this.welcomeMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.welcomeMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebExperienceRequest)) {
            return false;
        }
        CreateWebExperienceRequest other = (CreateWebExperienceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString()) && Objects.equals(this.subtitle(), other.subtitle()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.welcomeMessage(), other.welcomeMessage());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebExperienceRequest").add("ApplicationId", (Object)this.applicationId()).add("ClientToken", (Object)this.clientToken()).add("RoleArn", (Object)this.roleArn()).add("SamplePromptsControlMode", (Object)this.samplePromptsControlModeAsString()).add("Subtitle", (Object)this.subtitle()).add("Tags", this.hasTags() ? this.tags() : null).add("Title", (Object)this.title()).add("WelcomeMessage", (Object)this.welcomeMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "samplePromptsControlMode": {
                return Optional.ofNullable(clazz.cast(this.samplePromptsControlModeAsString()));
            }
            case "subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "welcomeMessage": {
                return Optional.ofNullable(clazz.cast(this.welcomeMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebExperienceRequest, T> g) {
        return obj -> g.apply((CreateWebExperienceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String clientToken;
        private String roleArn;
        private String samplePromptsControlMode;
        private String subtitle;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String title;
        private String welcomeMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebExperienceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.clientToken(model.clientToken);
            this.roleArn(model.roleArn);
            this.samplePromptsControlMode(model.samplePromptsControlMode);
            this.subtitle(model.subtitle);
            this.tags(model.tags);
            this.title(model.title);
            this.welcomeMessage(model.welcomeMessage);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return this.samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final String getSubtitle() {
            return this.subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebExperienceRequest build() {
            return new CreateWebExperienceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebExperienceRequest> {
        public Builder applicationId(String var1);

        public Builder clientToken(String var1);

        public Builder roleArn(String var1);

        public Builder samplePromptsControlMode(String var1);

        public Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode var1);

        public Builder subtitle(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder title(String var1);

        public Builder welcomeMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

