/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.EligibleDataSource;
import software.amazon.awssdk.services.qbusiness.model.EligibleDataSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentRetrievalRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentRetrievalRule> {
    private static final SdkField<List<EligibleDataSource>> ELIGIBLE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eligibleDataSources").getter(ContentRetrievalRule.getter(ContentRetrievalRule::eligibleDataSources)).setter(ContentRetrievalRule.setter(Builder::eligibleDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eligibleDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EligibleDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELIGIBLE_DATA_SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EligibleDataSource> eligibleDataSources;

    private ContentRetrievalRule(BuilderImpl builder) {
        this.eligibleDataSources = builder.eligibleDataSources;
    }

    public final boolean hasEligibleDataSources() {
        return this.eligibleDataSources != null && !(this.eligibleDataSources instanceof SdkAutoConstructList);
    }

    public final List<EligibleDataSource> eligibleDataSources() {
        return this.eligibleDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEligibleDataSources() ? this.eligibleDataSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentRetrievalRule)) {
            return false;
        }
        ContentRetrievalRule other = (ContentRetrievalRule)obj;
        return this.hasEligibleDataSources() == other.hasEligibleDataSources() && Objects.equals(this.eligibleDataSources(), other.eligibleDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"ContentRetrievalRule").add("EligibleDataSources", this.hasEligibleDataSources() ? this.eligibleDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eligibleDataSources": {
                return Optional.ofNullable(clazz.cast(this.eligibleDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentRetrievalRule, T> g) {
        return obj -> g.apply((ContentRetrievalRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EligibleDataSource> eligibleDataSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentRetrievalRule model) {
            this.eligibleDataSources(model.eligibleDataSources);
        }

        public final List<EligibleDataSource.Builder> getEligibleDataSources() {
            List<EligibleDataSource.Builder> result = EligibleDataSourcesCopier.copyToBuilder(this.eligibleDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEligibleDataSources(Collection<EligibleDataSource.BuilderImpl> eligibleDataSources) {
            this.eligibleDataSources = EligibleDataSourcesCopier.copyFromBuilder(eligibleDataSources);
        }

        @Override
        public final Builder eligibleDataSources(Collection<EligibleDataSource> eligibleDataSources) {
            this.eligibleDataSources = EligibleDataSourcesCopier.copy(eligibleDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eligibleDataSources(EligibleDataSource ... eligibleDataSources) {
            this.eligibleDataSources(Arrays.asList(eligibleDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eligibleDataSources(Consumer<EligibleDataSource.Builder> ... eligibleDataSources) {
            this.eligibleDataSources(Stream.of(eligibleDataSources).map(c -> (EligibleDataSource)((EligibleDataSource.Builder)EligibleDataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContentRetrievalRule build() {
            return new ContentRetrievalRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentRetrievalRule> {
        public Builder eligibleDataSources(Collection<EligibleDataSource> var1);

        public Builder eligibleDataSources(EligibleDataSource ... var1);

        public Builder eligibleDataSources(Consumer<EligibleDataSource.Builder> ... var1);
    }
}

