/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.Retriever;

public class ListRetrieversPublisher
implements SdkPublisher<ListRetrieversResponse> {
    private final QBusinessAsyncClient client;
    private final ListRetrieversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRetrieversPublisher(QBusinessAsyncClient client, ListRetrieversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRetrieversPublisher(QBusinessAsyncClient client, ListRetrieversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRetrieversResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRetrieversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Retriever> retrievers() {
        Function<ListRetrieversResponse, Iterator> getIterator = response -> {
            if (response != null && response.retrievers() != null) {
                return response.retrievers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRetrieversResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRetrieversResponseFetcher
    implements AsyncPageFetcher<ListRetrieversResponse> {
        private ListRetrieversResponseFetcher() {
        }

        public boolean hasNextPage(ListRetrieversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRetrieversResponse> nextPage(ListRetrieversResponse previousPage) {
            if (previousPage == null) {
                return ListRetrieversPublisher.this.client.listRetrievers(ListRetrieversPublisher.this.firstRequest);
            }
            return ListRetrieversPublisher.this.client.listRetrievers((ListRetrieversRequest)((Object)ListRetrieversPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

