/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.EncryptionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PersonalizationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QAppsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateApplicationRequest.getter(CreateApplicationRequest::displayName)).setter(CreateApplicationRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateApplicationRequest.getter(CreateApplicationRequest::roleArn)).setter(CreateApplicationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityCenterInstanceArn").getter(CreateApplicationRequest.getter(CreateApplicationRequest::identityCenterInstanceArn)).setter(CreateApplicationRequest.setter(Builder::identityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateApplicationRequest.getter(CreateApplicationRequest::description)).setter(CreateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::encryptionConfiguration)).setter(CreateApplicationRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateApplicationRequest.getter(CreateApplicationRequest::clientToken)).setter(CreateApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attachmentsConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::attachmentsConfiguration)).setter(CreateApplicationRequest.setter(Builder::attachmentsConfiguration)).constructor(AttachmentsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build()}).build();
    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qAppsConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::qAppsConfiguration)).setter(CreateApplicationRequest.setter(Builder::qAppsConfiguration)).constructor(QAppsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build()}).build();
    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("personalizationConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::personalizationConfiguration)).setter(CreateApplicationRequest.setter(Builder::personalizationConfiguration)).constructor(PersonalizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, ROLE_ARN_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, ATTACHMENTS_CONFIGURATION_FIELD, Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD));
    private final String displayName;
    private final String roleArn;
    private final String identityCenterInstanceArn;
    private final String description;
    private final EncryptionConfiguration encryptionConfiguration;
    private final List<Tag> tags;
    private final String clientToken;
    private final AttachmentsConfiguration attachmentsConfiguration;
    private final QAppsConfiguration qAppsConfiguration;
    private final PersonalizationConfiguration personalizationConfiguration;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String identityCenterInstanceArn() {
        return this.identityCenterInstanceArn;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AttachmentsConfiguration attachmentsConfiguration() {
        return this.attachmentsConfiguration;
    }

    public final QAppsConfiguration qAppsConfiguration() {
        return this.qAppsConfiguration;
    }

    public final PersonalizationConfiguration personalizationConfiguration() {
        return this.personalizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.identityCenterInstanceArn(), other.identityCenterInstanceArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.attachmentsConfiguration(), other.attachmentsConfiguration()) && Objects.equals(this.qAppsConfiguration(), other.qAppsConfiguration()) && Objects.equals(this.personalizationConfiguration(), other.personalizationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("DisplayName", (Object)this.displayName()).add("RoleArn", (Object)this.roleArn()).add("IdentityCenterInstanceArn", (Object)this.identityCenterInstanceArn()).add("Description", (Object)this.description()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("AttachmentsConfiguration", (Object)this.attachmentsConfiguration()).add("QAppsConfiguration", (Object)this.qAppsConfiguration()).add("PersonalizationConfiguration", (Object)this.personalizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "identityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterInstanceArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "attachmentsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attachmentsConfiguration()));
            }
            case "qAppsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qAppsConfiguration()));
            }
            case "personalizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.personalizationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String roleArn;
        private String identityCenterInstanceArn;
        private String description;
        private EncryptionConfiguration encryptionConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private AttachmentsConfiguration attachmentsConfiguration;
        private QAppsConfiguration qAppsConfiguration;
        private PersonalizationConfiguration personalizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.roleArn(model.roleArn);
            this.identityCenterInstanceArn(model.identityCenterInstanceArn);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.attachmentsConfiguration(model.attachmentsConfiguration);
            this.qAppsConfiguration(model.qAppsConfiguration);
            this.personalizationConfiguration(model.personalizationConfiguration);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return this.identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return this.attachmentsConfiguration != null ? this.attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return this.qAppsConfiguration != null ? this.qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return this.personalizationConfiguration != null ? this.personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build() : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder displayName(String var1);

        public Builder roleArn(String var1);

        public Builder identityCenterInstanceArn(String var1);

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder attachmentsConfiguration(AttachmentsConfiguration var1);

        default public Builder attachmentsConfiguration(Consumer<AttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return this.attachmentsConfiguration((AttachmentsConfiguration)((AttachmentsConfiguration.Builder)AttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration)).build());
        }

        public Builder qAppsConfiguration(QAppsConfiguration var1);

        default public Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return this.qAppsConfiguration((QAppsConfiguration)((QAppsConfiguration.Builder)QAppsConfiguration.builder().applyMutation(qAppsConfiguration)).build());
        }

        public Builder personalizationConfiguration(PersonalizationConfiguration var1);

        default public Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return this.personalizationConfiguration((PersonalizationConfiguration)((PersonalizationConfiguration.Builder)PersonalizationConfiguration.builder().applyMutation(personalizationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

