/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a file uploaded during chat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentOutput.Builder, AttachmentOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AttachmentOutput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AttachmentOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(AttachmentOutput::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final ErrorDetail error;

    private AttachmentOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.error = builder.error;
    }

    /**
     * <p>
     * The name of a file uploaded during chat.
     * </p>
     * 
     * @return The name of a file uploaded during chat.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of a file uploaded during chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a file uploaded during chat.
     * @see AttachmentStatus
     */
    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a file uploaded during chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a file uploaded during chat.
     * @see AttachmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error associated with a file uploaded during chat.
     * </p>
     * 
     * @return An error associated with a file uploaded during chat.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentOutput)) {
            return false;
        }
        AttachmentOutput other = (AttachmentOutput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachmentOutput").add("Name", name()).add("Status", statusAsString()).add("Error", error())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentOutput, T> g) {
        return obj -> g.apply((AttachmentOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentOutput> {
        /**
         * <p>
         * The name of a file uploaded during chat.
         * </p>
         * 
         * @param name
         *        The name of a file uploaded during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of a file uploaded during chat.
         * </p>
         * 
         * @param status
         *        The status of a file uploaded during chat.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a file uploaded during chat.
         * </p>
         * 
         * @param status
         *        The status of a file uploaded during chat.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);

        /**
         * <p>
         * An error associated with a file uploaded during chat.
         * </p>
         * 
         * @param error
         *        An error associated with a file uploaded during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error associated with a file uploaded during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentOutput model) {
            name(model.name);
            status(model.status);
            error(model.error);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public AttachmentOutput build() {
            return new AttachmentOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
