/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information required to create a custom plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPluginConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPluginConfiguration.Builder, CustomPluginConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CustomPluginConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> API_SCHEMA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiSchemaType").getter(getter(CustomPluginConfiguration::apiSchemaTypeAsString))
            .setter(setter(Builder::apiSchemaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchemaType").build()).build();

    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.<APISchema> builder(MarshallingType.SDK_POJO)
            .memberName("apiSchema").getter(getter(CustomPluginConfiguration::apiSchema)).setter(setter(Builder::apiSchema))
            .constructor(APISchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            API_SCHEMA_TYPE_FIELD, API_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String apiSchemaType;

    private final APISchema apiSchema;

    private CustomPluginConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.apiSchemaType = builder.apiSchemaType;
        this.apiSchema = builder.apiSchema;
    }

    /**
     * <p>
     * A description for your custom plugin configuration.
     * </p>
     * 
     * @return A description for your custom plugin configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of OpenAPI schema to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiSchemaType}
     * will return {@link APISchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiSchemaTypeAsString}.
     * </p>
     * 
     * @return The type of OpenAPI schema to use.
     * @see APISchemaType
     */
    public final APISchemaType apiSchemaType() {
        return APISchemaType.fromValue(apiSchemaType);
    }

    /**
     * <p>
     * The type of OpenAPI schema to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiSchemaType}
     * will return {@link APISchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiSchemaTypeAsString}.
     * </p>
     * 
     * @return The type of OpenAPI schema to use.
     * @see APISchemaType
     */
    public final String apiSchemaTypeAsString() {
        return apiSchemaType;
    }

    /**
     * <p>
     * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
     * YAML-formatted payload defining the schema.
     * </p>
     * 
     * @return Contains either details about the S3 object containing the OpenAPI schema for the action group or the
     *         JSON or YAML-formatted payload defining the schema.
     */
    public final APISchema apiSchema() {
        return apiSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(apiSchemaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginConfiguration)) {
            return false;
        }
        CustomPluginConfiguration other = (CustomPluginConfiguration) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(apiSchemaTypeAsString(), other.apiSchemaTypeAsString())
                && Objects.equals(apiSchema(), other.apiSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPluginConfiguration").add("Description", description())
                .add("ApiSchemaType", apiSchemaTypeAsString()).add("ApiSchema", apiSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "apiSchemaType":
            return Optional.ofNullable(clazz.cast(apiSchemaTypeAsString()));
        case "apiSchema":
            return Optional.ofNullable(clazz.cast(apiSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginConfiguration, T> g) {
        return obj -> g.apply((CustomPluginConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPluginConfiguration> {
        /**
         * <p>
         * A description for your custom plugin configuration.
         * </p>
         * 
         * @param description
         *        A description for your custom plugin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of OpenAPI schema to use.
         * </p>
         * 
         * @param apiSchemaType
         *        The type of OpenAPI schema to use.
         * @see APISchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see APISchemaType
         */
        Builder apiSchemaType(String apiSchemaType);

        /**
         * <p>
         * The type of OpenAPI schema to use.
         * </p>
         * 
         * @param apiSchemaType
         *        The type of OpenAPI schema to use.
         * @see APISchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see APISchemaType
         */
        Builder apiSchemaType(APISchemaType apiSchemaType);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema.
         * </p>
         * 
         * @param apiSchema
         *        Contains either details about the S3 object containing the OpenAPI schema for the action group or the
         *        JSON or YAML-formatted payload defining the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSchema(APISchema apiSchema);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link APISchema.Builder} avoiding the need to
         * create one manually via {@link APISchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APISchema.Builder#build()} is called immediately and its result
         * is passed to {@link #apiSchema(APISchema)}.
         * 
         * @param apiSchema
         *        a consumer that will call methods on {@link APISchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiSchema(APISchema)
         */
        default Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return apiSchema(APISchema.builder().applyMutation(apiSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String apiSchemaType;

        private APISchema apiSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginConfiguration model) {
            description(model.description);
            apiSchemaType(model.apiSchemaType);
            apiSchema(model.apiSchema);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getApiSchemaType() {
            return apiSchemaType;
        }

        public final void setApiSchemaType(String apiSchemaType) {
            this.apiSchemaType = apiSchemaType;
        }

        @Override
        public final Builder apiSchemaType(String apiSchemaType) {
            this.apiSchemaType = apiSchemaType;
            return this;
        }

        @Override
        public final Builder apiSchemaType(APISchemaType apiSchemaType) {
            this.apiSchemaType(apiSchemaType == null ? null : apiSchemaType.toString());
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return apiSchema != null ? apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        @Override
        public CustomPluginConfiguration build() {
            return new CustomPluginConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
