/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about index capacity configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexCapacityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IndexCapacityConfiguration.Builder, IndexCapacityConfiguration> {
    private static final SdkField<Integer> UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("units")
            .getter(getter(IndexCapacityConfiguration::units)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer units;

    private IndexCapacityConfiguration(BuilderImpl builder) {
        this.units = builder.units;
    }

    /**
     * <p>
     * The number of storage units configured for an Amazon Q Business index.
     * </p>
     * 
     * @return The number of storage units configured for an Amazon Q Business index.
     */
    public final Integer units() {
        return units;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(units());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexCapacityConfiguration)) {
            return false;
        }
        IndexCapacityConfiguration other = (IndexCapacityConfiguration) obj;
        return Objects.equals(units(), other.units());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexCapacityConfiguration").add("Units", units()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "units":
            return Optional.ofNullable(clazz.cast(units()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexCapacityConfiguration, T> g) {
        return obj -> g.apply((IndexCapacityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexCapacityConfiguration> {
        /**
         * <p>
         * The number of storage units configured for an Amazon Q Business index.
         * </p>
         * 
         * @param units
         *        The number of storage units configured for an Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder units(Integer units);
    }

    static final class BuilderImpl implements Builder {
        private Integer units;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexCapacityConfiguration model) {
            units(model.units);
        }

        public final Integer getUnits() {
            return units;
        }

        public final void setUnits(Integer units) {
            this.units = units;
        }

        @Override
        public final Builder units(Integer units) {
            this.units = units;
            return this;
        }

        @Override
        public IndexCapacityConfiguration build() {
            return new IndexCapacityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
