/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about chat response personalization. For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing chat
 * responses</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonalizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PersonalizationConfiguration.Builder, PersonalizationConfiguration> {
    private static final SdkField<String> PERSONALIZATION_CONTROL_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("personalizationControlMode")
            .getter(getter(PersonalizationConfiguration::personalizationControlModeAsString))
            .setter(setter(Builder::personalizationControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationControlMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERSONALIZATION_CONTROL_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String personalizationControlMode;

    private PersonalizationConfiguration(BuilderImpl builder) {
        this.personalizationControlMode = builder.personalizationControlMode;
    }

    /**
     * <p>
     * An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically,
     * location and job information—in your IAM Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationControlMode} will return {@link PersonalizationControlMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #personalizationControlModeAsString}.
     * </p>
     * 
     * @return An option to allow Amazon Q Business to customize chat responses using user specific
     *         metadata—specifically, location and job information—in your IAM Identity Center instance.
     * @see PersonalizationControlMode
     */
    public final PersonalizationControlMode personalizationControlMode() {
        return PersonalizationControlMode.fromValue(personalizationControlMode);
    }

    /**
     * <p>
     * An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically,
     * location and job information—in your IAM Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationControlMode} will return {@link PersonalizationControlMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #personalizationControlModeAsString}.
     * </p>
     * 
     * @return An option to allow Amazon Q Business to customize chat responses using user specific
     *         metadata—specifically, location and job information—in your IAM Identity Center instance.
     * @see PersonalizationControlMode
     */
    public final String personalizationControlModeAsString() {
        return personalizationControlMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(personalizationControlModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonalizationConfiguration)) {
            return false;
        }
        PersonalizationConfiguration other = (PersonalizationConfiguration) obj;
        return Objects.equals(personalizationControlModeAsString(), other.personalizationControlModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PersonalizationConfiguration")
                .add("PersonalizationControlMode", personalizationControlModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "personalizationControlMode":
            return Optional.ofNullable(clazz.cast(personalizationControlModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersonalizationConfiguration, T> g) {
        return obj -> g.apply((PersonalizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersonalizationConfiguration> {
        /**
         * <p>
         * An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically,
         * location and job information—in your IAM Identity Center instance.
         * </p>
         * 
         * @param personalizationControlMode
         *        An option to allow Amazon Q Business to customize chat responses using user specific
         *        metadata—specifically, location and job information—in your IAM Identity Center instance.
         * @see PersonalizationControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationControlMode
         */
        Builder personalizationControlMode(String personalizationControlMode);

        /**
         * <p>
         * An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically,
         * location and job information—in your IAM Identity Center instance.
         * </p>
         * 
         * @param personalizationControlMode
         *        An option to allow Amazon Q Business to customize chat responses using user specific
         *        metadata—specifically, location and job information—in your IAM Identity Center instance.
         * @see PersonalizationControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationControlMode
         */
        Builder personalizationControlMode(PersonalizationControlMode personalizationControlMode);
    }

    static final class BuilderImpl implements Builder {
        private String personalizationControlMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonalizationConfiguration model) {
            personalizationControlMode(model.personalizationControlMode);
        }

        public final String getPersonalizationControlMode() {
            return personalizationControlMode;
        }

        public final void setPersonalizationControlMode(String personalizationControlMode) {
            this.personalizationControlMode = personalizationControlMode;
        }

        @Override
        public final Builder personalizationControlMode(String personalizationControlMode) {
            this.personalizationControlMode = personalizationControlMode;
            return this;
        }

        @Override
        public final Builder personalizationControlMode(PersonalizationControlMode personalizationControlMode) {
            this.personalizationControlMode(personalizationControlMode == null ? null : personalizationControlMode.toString());
            return this;
        }

        @Override
        public PersonalizationConfiguration build() {
            return new PersonalizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
