/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGroupRequest extends QBusinessRequest implements
        ToCopyableBuilder<PutGroupRequest.Builder, PutGroupRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(PutGroupRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(PutGroupRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(PutGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(PutGroupRequest::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PutGroupRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<GroupMembers> GROUP_MEMBERS_FIELD = SdkField.<GroupMembers> builder(MarshallingType.SDK_POJO)
            .memberName("groupMembers").getter(getter(PutGroupRequest::groupMembers)).setter(setter(Builder::groupMembers))
            .constructor(GroupMembers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupMembers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, GROUP_NAME_FIELD, DATA_SOURCE_ID_FIELD, TYPE_FIELD, GROUP_MEMBERS_FIELD));

    private final String applicationId;

    private final String indexId;

    private final String groupName;

    private final String dataSourceId;

    private final String type;

    private final GroupMembers groupMembers;

    private PutGroupRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.groupName = builder.groupName;
        this.dataSourceId = builder.dataSourceId;
        this.type = builder.type;
        this.groupMembers = builder.groupMembers;
    }

    /**
     * <p>
     * The identifier of the application in which the user and group mapping belongs.
     * </p>
     * 
     * @return The identifier of the application in which the user and group mapping belongs.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the index in which you want to map users to their groups.
     * </p>
     * 
     * @return The identifier of the index in which you want to map users to their groups.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The list that contains your users or sub groups that belong the same group. For example, the group "Company"
     * includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
     * </p>
     * <p>
     * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
     * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the
     * list of sub groups that belong to a group (and/or users) must be no more than 1000.
     * </p>
     * 
     * @return The list that contains your users or sub groups that belong the same group. For example, the group
     *         "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and
     *         "Sales and Marketing".</p>
     *         <p>
     *         If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
     *         the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000
     *         users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The identifier of the data source for which you want to map users to their groups. This is useful if a group is
     * tied to multiple data sources, but you only want the group to access documents of a certain data source. For
     * example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents
     * stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to
     * customer-related documents stored in Salesforce.
     * </p>
     * 
     * @return The identifier of the data source for which you want to map users to their groups. This is useful if a
     *         group is tied to multiple data sources, but you only want the group to access documents of a certain data
     *         source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the
     *         company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing"
     *         team only needs access to customer-related documents stored in Salesforce.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The type of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the group.
     * @see MembershipType
     */
    public final MembershipType type() {
        return MembershipType.fromValue(type);
    }

    /**
     * <p>
     * The type of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the group.
     * @see MembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the GroupMembers property for this object.
     * 
     * @return The value of the GroupMembers property for this object.
     */
    public final GroupMembers groupMembers() {
        return groupMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupMembers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupRequest)) {
            return false;
        }
        PutGroupRequest other = (PutGroupRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(groupMembers(), other.groupMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGroupRequest").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("GroupName", groupName()).add("DataSourceId", dataSourceId()).add("Type", typeAsString())
                .add("GroupMembers", groupMembers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "groupMembers":
            return Optional.ofNullable(clazz.cast(groupMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGroupRequest, T> g) {
        return obj -> g.apply((PutGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutGroupRequest> {
        /**
         * <p>
         * The identifier of the application in which the user and group mapping belongs.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application in which the user and group mapping belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the index in which you want to map users to their groups.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index in which you want to map users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The list that contains your users or sub groups that belong the same group. For example, the group "Company"
         * includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
         * </p>
         * <p>
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
         * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         * </p>
         * 
         * @param groupName
         *        The list that contains your users or sub groups that belong the same group. For example, the group
         *        "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and
         *        "Sales and Marketing".</p>
         *        <p>
         *        If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
         *        the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than
         *        1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than
         *        1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The identifier of the data source for which you want to map users to their groups. This is useful if a group
         * is tied to multiple data sources, but you only want the group to access documents of a certain data source.
         * For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's
         * documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only
         * needs access to customer-related documents stored in Salesforce.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source for which you want to map users to their groups. This is useful if a
         *        group is tied to multiple data sources, but you only want the group to access documents of a certain
         *        data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied
         *        to the company's documents stored in the data sources Confluence and Salesforce. However,
         *        "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The type of the group.
         * </p>
         * 
         * @param type
         *        The type of the group.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the group.
         * </p>
         * 
         * @param type
         *        The type of the group.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder type(MembershipType type);

        /**
         * Sets the value of the GroupMembers property for this object.
         *
         * @param groupMembers
         *        The new value for the GroupMembers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupMembers(GroupMembers groupMembers);

        /**
         * Sets the value of the GroupMembers property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GroupMembers.Builder} avoiding the need
         * to create one manually via {@link GroupMembers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupMembers.Builder#build()} is called immediately and its
         * result is passed to {@link #groupMembers(GroupMembers)}.
         * 
         * @param groupMembers
         *        a consumer that will call methods on {@link GroupMembers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupMembers(GroupMembers)
         */
        default Builder groupMembers(Consumer<GroupMembers.Builder> groupMembers) {
            return groupMembers(GroupMembers.builder().applyMutation(groupMembers).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String groupName;

        private String dataSourceId;

        private String type;

        private GroupMembers groupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(PutGroupRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            groupName(model.groupName);
            dataSourceId(model.dataSourceId);
            type(model.type);
            groupMembers(model.groupMembers);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final GroupMembers.Builder getGroupMembers() {
            return groupMembers != null ? groupMembers.toBuilder() : null;
        }

        public final void setGroupMembers(GroupMembers.BuilderImpl groupMembers) {
            this.groupMembers = groupMembers != null ? groupMembers.build() : null;
        }

        @Override
        public final Builder groupMembers(GroupMembers groupMembers) {
            this.groupMembers = groupMembers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGroupRequest build() {
            return new PutGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
