/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityCenterInstanceArn").getter(getter(UpdateApplicationRequest::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateApplicationRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateApplicationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<AttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField
            .<AttachmentsConfiguration> builder(MarshallingType.SDK_POJO).memberName("attachmentsConfiguration")
            .getter(getter(UpdateApplicationRequest::attachmentsConfiguration)).setter(setter(Builder::attachmentsConfiguration))
            .constructor(AttachmentsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build())
            .build();

    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField
            .<QAppsConfiguration> builder(MarshallingType.SDK_POJO).memberName("qAppsConfiguration")
            .getter(getter(UpdateApplicationRequest::qAppsConfiguration)).setter(setter(Builder::qAppsConfiguration))
            .constructor(QAppsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build())
            .build();

    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField
            .<PersonalizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("personalizationConfiguration")
            .getter(getter(UpdateApplicationRequest::personalizationConfiguration))
            .setter(setter(Builder::personalizationConfiguration))
            .constructor(PersonalizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            IDENTITY_CENTER_INSTANCE_ARN_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD,
            ATTACHMENTS_CONFIGURATION_FIELD, Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD));

    private final String applicationId;

    private final String identityCenterInstanceArn;

    private final String displayName;

    private final String description;

    private final String roleArn;

    private final AttachmentsConfiguration attachmentsConfiguration;

    private final QAppsConfiguration qAppsConfiguration;

    private final PersonalizationConfiguration personalizationConfiguration;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting
     * to—your Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or
     *         connecting to—your Amazon Q Business application.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    /**
     * <p>
     * A name for the Amazon Q Business application.
     * </p>
     * 
     * @return A name for the Amazon Q Business application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A description for the Amazon Q Business application.
     * </p>
     * 
     * @return A description for the Amazon Q Business application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business permission to
     * access Amazon CloudWatch logs and metrics.
     * </p>
     * 
     * @return An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business permission
     *         to access Amazon CloudWatch logs and metrics.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An option to allow end users to upload files directly during chat.
     * </p>
     * 
     * @return An option to allow end users to upload files directly during chat.
     */
    public final AttachmentsConfiguration attachmentsConfiguration() {
        return attachmentsConfiguration;
    }

    /**
     * <p>
     * An option to allow end users to create and use Amazon Q Apps in the web experience.
     * </p>
     * 
     * @return An option to allow end users to create and use Amazon Q Apps in the web experience.
     */
    public final QAppsConfiguration qAppsConfiguration() {
        return qAppsConfiguration;
    }

    /**
     * <p>
     * Configuration information about chat response personalization. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing
     * chat responses</a>.
     * </p>
     * 
     * @return Configuration information about chat response personalization. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
     *         >Personalizing chat responses</a>.
     */
    public final PersonalizationConfiguration personalizationConfiguration() {
        return personalizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(personalizationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(attachmentsConfiguration(), other.attachmentsConfiguration())
                && Objects.equals(qAppsConfiguration(), other.qAppsConfiguration())
                && Objects.equals(personalizationConfiguration(), other.personalizationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationId", applicationId())
                .add("IdentityCenterInstanceArn", identityCenterInstanceArn()).add("DisplayName", displayName())
                .add("Description", description()).add("RoleArn", roleArn())
                .add("AttachmentsConfiguration", attachmentsConfiguration()).add("QAppsConfiguration", qAppsConfiguration())
                .add("PersonalizationConfiguration", personalizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "identityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "attachmentsConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentsConfiguration()));
        case "qAppsConfiguration":
            return Optional.ofNullable(clazz.cast(qAppsConfiguration()));
        case "personalizationConfiguration":
            return Optional.ofNullable(clazz.cast(personalizationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting
         * to—your Amazon Q Business application.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or
         *        connecting to—your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);

        /**
         * <p>
         * A name for the Amazon Q Business application.
         * </p>
         * 
         * @param displayName
         *        A name for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A description for the Amazon Q Business application.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business permission to
         * access Amazon CloudWatch logs and metrics.
         * </p>
         * 
         * @param roleArn
         *        An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business
         *        permission to access Amazon CloudWatch logs and metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * 
         * @param attachmentsConfiguration
         *        An option to allow end users to upload files directly during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachmentsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AttachmentsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentsConfiguration(AttachmentsConfiguration)}.
         * 
         * @param attachmentsConfiguration
         *        a consumer that will call methods on {@link AttachmentsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsConfiguration(AttachmentsConfiguration)
         */
        default Builder attachmentsConfiguration(Consumer<AttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return attachmentsConfiguration(AttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration).build());
        }

        /**
         * <p>
         * An option to allow end users to create and use Amazon Q Apps in the web experience.
         * </p>
         * 
         * @param qAppsConfiguration
         *        An option to allow end users to create and use Amazon Q Apps in the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration);

        /**
         * <p>
         * An option to allow end users to create and use Amazon Q Apps in the web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link QAppsConfiguration.Builder} avoiding the
         * need to create one manually via {@link QAppsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QAppsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #qAppsConfiguration(QAppsConfiguration)}.
         * 
         * @param qAppsConfiguration
         *        a consumer that will call methods on {@link QAppsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qAppsConfiguration(QAppsConfiguration)
         */
        default Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return qAppsConfiguration(QAppsConfiguration.builder().applyMutation(qAppsConfiguration).build());
        }

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>.
         * </p>
         * 
         * @param personalizationConfiguration
         *        Configuration information about chat response personalization. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         *        >Personalizing chat responses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration);

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PersonalizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link PersonalizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PersonalizationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #personalizationConfiguration(PersonalizationConfiguration)}.
         * 
         * @param personalizationConfiguration
         *        a consumer that will call methods on {@link PersonalizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalizationConfiguration(PersonalizationConfiguration)
         */
        default Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return personalizationConfiguration(PersonalizationConfiguration.builder()
                    .applyMutation(personalizationConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String identityCenterInstanceArn;

        private String displayName;

        private String description;

        private String roleArn;

        private AttachmentsConfiguration attachmentsConfiguration;

        private QAppsConfiguration qAppsConfiguration;

        private PersonalizationConfiguration personalizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            identityCenterInstanceArn(model.identityCenterInstanceArn);
            displayName(model.displayName);
            description(model.description);
            roleArn(model.roleArn);
            attachmentsConfiguration(model.attachmentsConfiguration);
            qAppsConfiguration(model.qAppsConfiguration);
            personalizationConfiguration(model.personalizationConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return attachmentsConfiguration != null ? attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return qAppsConfiguration != null ? qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return personalizationConfiguration != null ? personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
