/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChatControlsConfigurationRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateChatControlsConfigurationRequest.Builder, UpdateChatControlsConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateChatControlsConfigurationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateChatControlsConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RESPONSE_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseScope").getter(getter(UpdateChatControlsConfigurationRequest::responseScopeAsString))
            .setter(setter(Builder::responseScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseScope").build()).build();

    private static final SdkField<BlockedPhrasesConfigurationUpdate> BLOCKED_PHRASES_CONFIGURATION_UPDATE_FIELD = SdkField
            .<BlockedPhrasesConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("blockedPhrasesConfigurationUpdate")
            .getter(getter(UpdateChatControlsConfigurationRequest::blockedPhrasesConfigurationUpdate))
            .setter(setter(Builder::blockedPhrasesConfigurationUpdate))
            .constructor(BlockedPhrasesConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesConfigurationUpdate")
                    .build()).build();

    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_TO_CREATE_OR_UPDATE_FIELD = SdkField
            .<List<TopicConfiguration>> builder(MarshallingType.LIST)
            .memberName("topicConfigurationsToCreateOrUpdate")
            .getter(getter(UpdateChatControlsConfigurationRequest::topicConfigurationsToCreateOrUpdate))
            .setter(setter(Builder::topicConfigurationsToCreateOrUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("topicConfigurationsToCreateOrUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_TO_DELETE_FIELD = SdkField
            .<List<TopicConfiguration>> builder(MarshallingType.LIST)
            .memberName("topicConfigurationsToDelete")
            .getter(getter(UpdateChatControlsConfigurationRequest::topicConfigurationsToDelete))
            .setter(setter(Builder::topicConfigurationsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicConfigurationsToDelete")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CreatorModeConfiguration> CREATOR_MODE_CONFIGURATION_FIELD = SdkField
            .<CreatorModeConfiguration> builder(MarshallingType.SDK_POJO).memberName("creatorModeConfiguration")
            .getter(getter(UpdateChatControlsConfigurationRequest::creatorModeConfiguration))
            .setter(setter(Builder::creatorModeConfiguration)).constructor(CreatorModeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorModeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CLIENT_TOKEN_FIELD, RESPONSE_SCOPE_FIELD, BLOCKED_PHRASES_CONFIGURATION_UPDATE_FIELD,
            TOPIC_CONFIGURATIONS_TO_CREATE_OR_UPDATE_FIELD, TOPIC_CONFIGURATIONS_TO_DELETE_FIELD,
            CREATOR_MODE_CONFIGURATION_FIELD));

    private final String applicationId;

    private final String clientToken;

    private final String responseScope;

    private final BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate;

    private final List<TopicConfiguration> topicConfigurationsToCreateOrUpdate;

    private final List<TopicConfiguration> topicConfigurationsToDelete;

    private final CreatorModeConfiguration creatorModeConfiguration;

    private UpdateChatControlsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.responseScope = builder.responseScope;
        this.blockedPhrasesConfigurationUpdate = builder.blockedPhrasesConfigurationUpdate;
        this.topicConfigurationsToCreateOrUpdate = builder.topicConfigurationsToCreateOrUpdate;
        this.topicConfigurationsToDelete = builder.topicConfigurationsToDelete;
        this.creatorModeConfiguration = builder.creatorModeConfiguration;
    }

    /**
     * <p>
     * The identifier of the application for which the chat controls are configured.
     * </p>
     * 
     * @return The identifier of the application for which the chat controls are configured.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A token that you provide to identify the request to update a Amazon Q Business application chat configuration.
     * </p>
     * 
     * @return A token that you provide to identify the request to update a Amazon Q Business application chat
     *         configuration.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The response scope configured for your application. This determines whether your application uses its retrieval
     * augmented generation (RAG) system to generate answers only from your enterprise data, or also uses the large
     * language models (LLM) knowledge to respons to end user questions in chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseScope}
     * will return {@link ResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseScopeAsString}.
     * </p>
     * 
     * @return The response scope configured for your application. This determines whether your application uses its
     *         retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also
     *         uses the large language models (LLM) knowledge to respons to end user questions in chat.
     * @see ResponseScope
     */
    public final ResponseScope responseScope() {
        return ResponseScope.fromValue(responseScope);
    }

    /**
     * <p>
     * The response scope configured for your application. This determines whether your application uses its retrieval
     * augmented generation (RAG) system to generate answers only from your enterprise data, or also uses the large
     * language models (LLM) knowledge to respons to end user questions in chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseScope}
     * will return {@link ResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseScopeAsString}.
     * </p>
     * 
     * @return The response scope configured for your application. This determines whether your application uses its
     *         retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also
     *         uses the large language models (LLM) knowledge to respons to end user questions in chat.
     * @see ResponseScope
     */
    public final String responseScopeAsString() {
        return responseScope;
    }

    /**
     * <p>
     * The phrases blocked from chat by your chat control configuration.
     * </p>
     * 
     * @return The phrases blocked from chat by your chat control configuration.
     */
    public final BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate() {
        return blockedPhrasesConfigurationUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicConfigurationsToCreateOrUpdate
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasTopicConfigurationsToCreateOrUpdate() {
        return topicConfigurationsToCreateOrUpdate != null
                && !(topicConfigurationsToCreateOrUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configured topic specific chat controls you want to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicConfigurationsToCreateOrUpdate}
     * method.
     * </p>
     * 
     * @return The configured topic specific chat controls you want to update.
     */
    public final List<TopicConfiguration> topicConfigurationsToCreateOrUpdate() {
        return topicConfigurationsToCreateOrUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicConfigurationsToDelete property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTopicConfigurationsToDelete() {
        return topicConfigurationsToDelete != null && !(topicConfigurationsToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configured topic specific chat controls you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicConfigurationsToDelete} method.
     * </p>
     * 
     * @return The configured topic specific chat controls you want to delete.
     */
    public final List<TopicConfiguration> topicConfigurationsToDelete() {
        return topicConfigurationsToDelete;
    }

    /**
     * <p>
     * The configuration details for <code>CREATOR_MODE</code>.
     * </p>
     * 
     * @return The configuration details for <code>CREATOR_MODE</code>.
     */
    public final CreatorModeConfiguration creatorModeConfiguration() {
        return creatorModeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(responseScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockedPhrasesConfigurationUpdate());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasTopicConfigurationsToCreateOrUpdate() ? topicConfigurationsToCreateOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicConfigurationsToDelete() ? topicConfigurationsToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorModeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChatControlsConfigurationRequest)) {
            return false;
        }
        UpdateChatControlsConfigurationRequest other = (UpdateChatControlsConfigurationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(responseScopeAsString(), other.responseScopeAsString())
                && Objects.equals(blockedPhrasesConfigurationUpdate(), other.blockedPhrasesConfigurationUpdate())
                && hasTopicConfigurationsToCreateOrUpdate() == other.hasTopicConfigurationsToCreateOrUpdate()
                && Objects.equals(topicConfigurationsToCreateOrUpdate(), other.topicConfigurationsToCreateOrUpdate())
                && hasTopicConfigurationsToDelete() == other.hasTopicConfigurationsToDelete()
                && Objects.equals(topicConfigurationsToDelete(), other.topicConfigurationsToDelete())
                && Objects.equals(creatorModeConfiguration(), other.creatorModeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateChatControlsConfigurationRequest")
                .add("ApplicationId", applicationId())
                .add("ClientToken", clientToken())
                .add("ResponseScope", responseScopeAsString())
                .add("BlockedPhrasesConfigurationUpdate", blockedPhrasesConfigurationUpdate())
                .add("TopicConfigurationsToCreateOrUpdate",
                        hasTopicConfigurationsToCreateOrUpdate() ? topicConfigurationsToCreateOrUpdate() : null)
                .add("TopicConfigurationsToDelete", hasTopicConfigurationsToDelete() ? topicConfigurationsToDelete() : null)
                .add("CreatorModeConfiguration", creatorModeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "responseScope":
            return Optional.ofNullable(clazz.cast(responseScopeAsString()));
        case "blockedPhrasesConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(blockedPhrasesConfigurationUpdate()));
        case "topicConfigurationsToCreateOrUpdate":
            return Optional.ofNullable(clazz.cast(topicConfigurationsToCreateOrUpdate()));
        case "topicConfigurationsToDelete":
            return Optional.ofNullable(clazz.cast(topicConfigurationsToDelete()));
        case "creatorModeConfiguration":
            return Optional.ofNullable(clazz.cast(creatorModeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChatControlsConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateChatControlsConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChatControlsConfigurationRequest> {
        /**
         * <p>
         * The identifier of the application for which the chat controls are configured.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application for which the chat controls are configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A token that you provide to identify the request to update a Amazon Q Business application chat
         * configuration.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to update a Amazon Q Business application chat
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The response scope configured for your application. This determines whether your application uses its
         * retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also uses
         * the large language models (LLM) knowledge to respons to end user questions in chat.
         * </p>
         * 
         * @param responseScope
         *        The response scope configured for your application. This determines whether your application uses its
         *        retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or
         *        also uses the large language models (LLM) knowledge to respons to end user questions in chat.
         * @see ResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseScope
         */
        Builder responseScope(String responseScope);

        /**
         * <p>
         * The response scope configured for your application. This determines whether your application uses its
         * retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also uses
         * the large language models (LLM) knowledge to respons to end user questions in chat.
         * </p>
         * 
         * @param responseScope
         *        The response scope configured for your application. This determines whether your application uses its
         *        retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or
         *        also uses the large language models (LLM) knowledge to respons to end user questions in chat.
         * @see ResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseScope
         */
        Builder responseScope(ResponseScope responseScope);

        /**
         * <p>
         * The phrases blocked from chat by your chat control configuration.
         * </p>
         * 
         * @param blockedPhrasesConfigurationUpdate
         *        The phrases blocked from chat by your chat control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate);

        /**
         * <p>
         * The phrases blocked from chat by your chat control configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BlockedPhrasesConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link BlockedPhrasesConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockedPhrasesConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate)}.
         * 
         * @param blockedPhrasesConfigurationUpdate
         *        a consumer that will call methods on {@link BlockedPhrasesConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate)
         */
        default Builder blockedPhrasesConfigurationUpdate(
                Consumer<BlockedPhrasesConfigurationUpdate.Builder> blockedPhrasesConfigurationUpdate) {
            return blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate.builder()
                    .applyMutation(blockedPhrasesConfigurationUpdate).build());
        }

        /**
         * <p>
         * The configured topic specific chat controls you want to update.
         * </p>
         * 
         * @param topicConfigurationsToCreateOrUpdate
         *        The configured topic specific chat controls you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurationsToCreateOrUpdate(Collection<TopicConfiguration> topicConfigurationsToCreateOrUpdate);

        /**
         * <p>
         * The configured topic specific chat controls you want to update.
         * </p>
         * 
         * @param topicConfigurationsToCreateOrUpdate
         *        The configured topic specific chat controls you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurationsToCreateOrUpdate(TopicConfiguration... topicConfigurationsToCreateOrUpdate);

        /**
         * <p>
         * The configured topic specific chat controls you want to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #topicConfigurationsToCreateOrUpdate(List<TopicConfiguration>)}.
         * 
         * @param topicConfigurationsToCreateOrUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicConfigurationsToCreateOrUpdate(java.util.Collection<TopicConfiguration>)
         */
        Builder topicConfigurationsToCreateOrUpdate(Consumer<TopicConfiguration.Builder>... topicConfigurationsToCreateOrUpdate);

        /**
         * <p>
         * The configured topic specific chat controls you want to delete.
         * </p>
         * 
         * @param topicConfigurationsToDelete
         *        The configured topic specific chat controls you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurationsToDelete(Collection<TopicConfiguration> topicConfigurationsToDelete);

        /**
         * <p>
         * The configured topic specific chat controls you want to delete.
         * </p>
         * 
         * @param topicConfigurationsToDelete
         *        The configured topic specific chat controls you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurationsToDelete(TopicConfiguration... topicConfigurationsToDelete);

        /**
         * <p>
         * The configured topic specific chat controls you want to delete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #topicConfigurationsToDelete(List<TopicConfiguration>)}.
         * 
         * @param topicConfigurationsToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicConfigurationsToDelete(java.util.Collection<TopicConfiguration>)
         */
        Builder topicConfigurationsToDelete(Consumer<TopicConfiguration.Builder>... topicConfigurationsToDelete);

        /**
         * <p>
         * The configuration details for <code>CREATOR_MODE</code>.
         * </p>
         * 
         * @param creatorModeConfiguration
         *        The configuration details for <code>CREATOR_MODE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorModeConfiguration(CreatorModeConfiguration creatorModeConfiguration);

        /**
         * <p>
         * The configuration details for <code>CREATOR_MODE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreatorModeConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreatorModeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreatorModeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #creatorModeConfiguration(CreatorModeConfiguration)}.
         * 
         * @param creatorModeConfiguration
         *        a consumer that will call methods on {@link CreatorModeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creatorModeConfiguration(CreatorModeConfiguration)
         */
        default Builder creatorModeConfiguration(Consumer<CreatorModeConfiguration.Builder> creatorModeConfiguration) {
            return creatorModeConfiguration(CreatorModeConfiguration.builder().applyMutation(creatorModeConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private String responseScope;

        private BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate;

        private List<TopicConfiguration> topicConfigurationsToCreateOrUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<TopicConfiguration> topicConfigurationsToDelete = DefaultSdkAutoConstructList.getInstance();

        private CreatorModeConfiguration creatorModeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChatControlsConfigurationRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            responseScope(model.responseScope);
            blockedPhrasesConfigurationUpdate(model.blockedPhrasesConfigurationUpdate);
            topicConfigurationsToCreateOrUpdate(model.topicConfigurationsToCreateOrUpdate);
            topicConfigurationsToDelete(model.topicConfigurationsToDelete);
            creatorModeConfiguration(model.creatorModeConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getResponseScope() {
            return responseScope;
        }

        public final void setResponseScope(String responseScope) {
            this.responseScope = responseScope;
        }

        @Override
        public final Builder responseScope(String responseScope) {
            this.responseScope = responseScope;
            return this;
        }

        @Override
        public final Builder responseScope(ResponseScope responseScope) {
            this.responseScope(responseScope == null ? null : responseScope.toString());
            return this;
        }

        public final BlockedPhrasesConfigurationUpdate.Builder getBlockedPhrasesConfigurationUpdate() {
            return blockedPhrasesConfigurationUpdate != null ? blockedPhrasesConfigurationUpdate.toBuilder() : null;
        }

        public final void setBlockedPhrasesConfigurationUpdate(
                BlockedPhrasesConfigurationUpdate.BuilderImpl blockedPhrasesConfigurationUpdate) {
            this.blockedPhrasesConfigurationUpdate = blockedPhrasesConfigurationUpdate != null ? blockedPhrasesConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate) {
            this.blockedPhrasesConfigurationUpdate = blockedPhrasesConfigurationUpdate;
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurationsToCreateOrUpdate() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier
                    .copyToBuilder(this.topicConfigurationsToCreateOrUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurationsToCreateOrUpdate(
                Collection<TopicConfiguration.BuilderImpl> topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate = TopicConfigurationsCopier
                    .copyFromBuilder(topicConfigurationsToCreateOrUpdate);
        }

        @Override
        public final Builder topicConfigurationsToCreateOrUpdate(
                Collection<TopicConfiguration> topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate = TopicConfigurationsCopier.copy(topicConfigurationsToCreateOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToCreateOrUpdate(TopicConfiguration... topicConfigurationsToCreateOrUpdate) {
            topicConfigurationsToCreateOrUpdate(Arrays.asList(topicConfigurationsToCreateOrUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToCreateOrUpdate(
                Consumer<TopicConfiguration.Builder>... topicConfigurationsToCreateOrUpdate) {
            topicConfigurationsToCreateOrUpdate(Stream.of(topicConfigurationsToCreateOrUpdate)
                    .map(c -> TopicConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurationsToDelete() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier.copyToBuilder(this.topicConfigurationsToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurationsToDelete(Collection<TopicConfiguration.BuilderImpl> topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete = TopicConfigurationsCopier.copyFromBuilder(topicConfigurationsToDelete);
        }

        @Override
        public final Builder topicConfigurationsToDelete(Collection<TopicConfiguration> topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete = TopicConfigurationsCopier.copy(topicConfigurationsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToDelete(TopicConfiguration... topicConfigurationsToDelete) {
            topicConfigurationsToDelete(Arrays.asList(topicConfigurationsToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToDelete(Consumer<TopicConfiguration.Builder>... topicConfigurationsToDelete) {
            topicConfigurationsToDelete(Stream.of(topicConfigurationsToDelete)
                    .map(c -> TopicConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreatorModeConfiguration.Builder getCreatorModeConfiguration() {
            return creatorModeConfiguration != null ? creatorModeConfiguration.toBuilder() : null;
        }

        public final void setCreatorModeConfiguration(CreatorModeConfiguration.BuilderImpl creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration != null ? creatorModeConfiguration.build() : null;
        }

        @Override
        public final Builder creatorModeConfiguration(CreatorModeConfiguration creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChatControlsConfigurationRequest build() {
            return new UpdateChatControlsConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
