/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateIndexRequest.Builder, UpdateIndexRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateIndexRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(UpdateIndexRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateIndexRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField
            .<IndexCapacityConfiguration> builder(MarshallingType.SDK_POJO).memberName("capacityConfiguration")
            .getter(getter(UpdateIndexRequest::capacityConfiguration)).setter(setter(Builder::capacityConfiguration))
            .constructor(IndexCapacityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build())
            .build();

    private static final SdkField<List<DocumentAttributeConfiguration>> DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD = SdkField
            .<List<DocumentAttributeConfiguration>> builder(MarshallingType.LIST)
            .memberName("documentAttributeConfigurations")
            .getter(getter(UpdateIndexRequest::documentAttributeConfigurations))
            .setter(setter(Builder::documentAttributeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributeConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttributeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttributeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CAPACITY_CONFIGURATION_FIELD,
            DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD));

    private final String applicationId;

    private final String indexId;

    private final String displayName;

    private final String description;

    private final IndexCapacityConfiguration capacityConfiguration;

    private final List<DocumentAttributeConfiguration> documentAttributeConfigurations;

    private UpdateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.documentAttributeConfigurations = builder.documentAttributeConfigurations;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application connected to the index.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application connected to the index.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business index.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business index.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The name of the Amazon Q Business index.
     * </p>
     * 
     * @return The name of the Amazon Q Business index.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the Amazon Q Business index.
     * </p>
     * 
     * @return The description of the Amazon Q Business index.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The storage capacity units you want to provision for your Amazon Q Business index. You can add and remove
     * capacity to fit your usage needs.
     * </p>
     * 
     * @return The storage capacity units you want to provision for your Amazon Q Business index. You can add and remove
     *         capacity to fit your usage needs.
     */
    public final IndexCapacityConfiguration capacityConfiguration() {
        return capacityConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributeConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentAttributeConfigurations() {
        return documentAttributeConfigurations != null && !(documentAttributeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for document metadata or fields. Document metadata are fields or attributes associated
     * with your documents. For example, the company department name associated with each document. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
     * >Understanding document attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributeConfigurations}
     * method.
     * </p>
     * 
     * @return Configuration information for document metadata or fields. Document metadata are fields or attributes
     *         associated with your documents. For example, the company department name associated with each document.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
     *         >Understanding document attributes</a>.
     */
    public final List<DocumentAttributeConfiguration> documentAttributeConfigurations() {
        return documentAttributeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capacityConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentAttributeConfigurations() ? documentAttributeConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexRequest)) {
            return false;
        }
        UpdateIndexRequest other = (UpdateIndexRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(capacityConfiguration(), other.capacityConfiguration())
                && hasDocumentAttributeConfigurations() == other.hasDocumentAttributeConfigurations()
                && Objects.equals(documentAttributeConfigurations(), other.documentAttributeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateIndexRequest")
                .add("ApplicationId", applicationId())
                .add("IndexId", indexId())
                .add("DisplayName", displayName())
                .add("Description", description())
                .add("CapacityConfiguration", capacityConfiguration())
                .add("DocumentAttributeConfigurations",
                        hasDocumentAttributeConfigurations() ? documentAttributeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "capacityConfiguration":
            return Optional.ofNullable(clazz.cast(capacityConfiguration()));
        case "documentAttributeConfigurations":
            return Optional.ofNullable(clazz.cast(documentAttributeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexRequest, T> g) {
        return obj -> g.apply((UpdateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIndexRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application connected to the index.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application connected to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the Amazon Q Business index.
         * </p>
         * 
         * @param indexId
         *        The identifier of the Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The name of the Amazon Q Business index.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the Amazon Q Business index.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The storage capacity units you want to provision for your Amazon Q Business index. You can add and remove
         * capacity to fit your usage needs.
         * </p>
         * 
         * @param capacityConfiguration
         *        The storage capacity units you want to provision for your Amazon Q Business index. You can add and
         *        remove capacity to fit your usage needs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration);

        /**
         * <p>
         * The storage capacity units you want to provision for your Amazon Q Business index. You can add and remove
         * capacity to fit your usage needs.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexCapacityConfiguration.Builder}
         * avoiding the need to create one manually via {@link IndexCapacityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexCapacityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityConfiguration(IndexCapacityConfiguration)}.
         * 
         * @param capacityConfiguration
         *        a consumer that will call methods on {@link IndexCapacityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityConfiguration(IndexCapacityConfiguration)
         */
        default Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return capacityConfiguration(IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration).build());
        }

        /**
         * <p>
         * Configuration information for document metadata or fields. Document metadata are fields or attributes
         * associated with your documents. For example, the company department name associated with each document. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * 
         * @param documentAttributeConfigurations
         *        Configuration information for document metadata or fields. Document metadata are fields or attributes
         *        associated with your documents. For example, the company department name associated with each
         *        document. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         *        >Understanding document attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> documentAttributeConfigurations);

        /**
         * <p>
         * Configuration information for document metadata or fields. Document metadata are fields or attributes
         * associated with your documents. For example, the company department name associated with each document. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * 
         * @param documentAttributeConfigurations
         *        Configuration information for document metadata or fields. Document metadata are fields or attributes
         *        associated with your documents. For example, the company department name associated with each
         *        document. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         *        >Understanding document attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeConfigurations(DocumentAttributeConfiguration... documentAttributeConfigurations);

        /**
         * <p>
         * Configuration information for document metadata or fields. Document metadata are fields or attributes
         * associated with your documents. For example, the company department name associated with each document. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #documentAttributeConfigurations(List<DocumentAttributeConfiguration>)}.
         * 
         * @param documentAttributeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeConfigurations(java.util.Collection<DocumentAttributeConfiguration>)
         */
        Builder documentAttributeConfigurations(
                Consumer<DocumentAttributeConfiguration.Builder>... documentAttributeConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String displayName;

        private String description;

        private IndexCapacityConfiguration capacityConfiguration;

        private List<DocumentAttributeConfiguration> documentAttributeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            displayName(model.displayName);
            description(model.description);
            capacityConfiguration(model.capacityConfiguration);
            documentAttributeConfigurations(model.documentAttributeConfigurations);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return capacityConfiguration != null ? capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final List<DocumentAttributeConfiguration.Builder> getDocumentAttributeConfigurations() {
            List<DocumentAttributeConfiguration.Builder> result = DocumentAttributeConfigurationsCopier
                    .copyToBuilder(this.documentAttributeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributeConfigurations(
                Collection<DocumentAttributeConfiguration.BuilderImpl> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier
                    .copyFromBuilder(documentAttributeConfigurations);
        }

        @Override
        public final Builder documentAttributeConfigurations(
                Collection<DocumentAttributeConfiguration> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copy(documentAttributeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(DocumentAttributeConfiguration... documentAttributeConfigurations) {
            documentAttributeConfigurations(Arrays.asList(documentAttributeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(
                Consumer<DocumentAttributeConfiguration.Builder>... documentAttributeConfigurations) {
            documentAttributeConfigurations(Stream.of(documentAttributeConfigurations)
                    .map(c -> DocumentAttributeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexRequest build() {
            return new UpdateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
