/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model.chatinputstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.qbusiness.model.ChatInputStream;
import software.amazon.awssdk.services.qbusiness.model.TextInputEvent;

/**
 * A specialization of {@code software.amazon.awssdk.services.qbusiness.model.TextInputEvent} that represents the
 * {@code ChatInputStream$textEvent} event. Do not use this class directly. Instead, use the static builder methods on
 * {@link software.amazon.awssdk.services.qbusiness.model.ChatInputStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultTextEvent extends TextInputEvent {
    private static final long serialVersionUID = 1L;

    DefaultTextEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public ChatInputStream.EventType sdkEventType() {
        return ChatInputStream.EventType.TEXT_EVENT;
    }

    public interface Builder extends TextInputEvent.Builder {
        @Override
        DefaultTextEvent build();
    }

    private static final class BuilderImpl extends TextInputEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultTextEvent event) {
            super(event);
        }

        @Override
        public DefaultTextEvent build() {
            return new DefaultTextEvent(this);
        }
    }
}
