/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the file upload during chat feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentsConfiguration.Builder, AttachmentsConfiguration> {
    private static final SdkField<String> ATTACHMENTS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentsControlMode").getter(getter(AttachmentsConfiguration::attachmentsControlModeAsString))
            .setter(setter(Builder::attachmentsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsControlMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTACHMENTS_CONTROL_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentsControlMode;

    private AttachmentsConfiguration(BuilderImpl builder) {
        this.attachmentsControlMode = builder.attachmentsControlMode;
    }

    /**
     * <p>
     * Status information about whether file upload functionality is activated or deactivated for your end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachmentsControlMode} will return {@link AttachmentsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attachmentsControlModeAsString}.
     * </p>
     * 
     * @return Status information about whether file upload functionality is activated or deactivated for your end user.
     * @see AttachmentsControlMode
     */
    public final AttachmentsControlMode attachmentsControlMode() {
        return AttachmentsControlMode.fromValue(attachmentsControlMode);
    }

    /**
     * <p>
     * Status information about whether file upload functionality is activated or deactivated for your end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachmentsControlMode} will return {@link AttachmentsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attachmentsControlModeAsString}.
     * </p>
     * 
     * @return Status information about whether file upload functionality is activated or deactivated for your end user.
     * @see AttachmentsControlMode
     */
    public final String attachmentsControlModeAsString() {
        return attachmentsControlMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsControlModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentsConfiguration)) {
            return false;
        }
        AttachmentsConfiguration other = (AttachmentsConfiguration) obj;
        return Objects.equals(attachmentsControlModeAsString(), other.attachmentsControlModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachmentsConfiguration").add("AttachmentsControlMode", attachmentsControlModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentsControlMode":
            return Optional.ofNullable(clazz.cast(attachmentsControlModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentsConfiguration, T> g) {
        return obj -> g.apply((AttachmentsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentsConfiguration> {
        /**
         * <p>
         * Status information about whether file upload functionality is activated or deactivated for your end user.
         * </p>
         * 
         * @param attachmentsControlMode
         *        Status information about whether file upload functionality is activated or deactivated for your end
         *        user.
         * @see AttachmentsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsControlMode
         */
        Builder attachmentsControlMode(String attachmentsControlMode);

        /**
         * <p>
         * Status information about whether file upload functionality is activated or deactivated for your end user.
         * </p>
         * 
         * @param attachmentsControlMode
         *        Status information about whether file upload functionality is activated or deactivated for your end
         *        user.
         * @see AttachmentsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsControlMode
         */
        Builder attachmentsControlMode(AttachmentsControlMode attachmentsControlMode);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentsControlMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentsConfiguration model) {
            attachmentsControlMode(model.attachmentsControlMode);
        }

        public final String getAttachmentsControlMode() {
            return attachmentsControlMode;
        }

        public final void setAttachmentsControlMode(String attachmentsControlMode) {
            this.attachmentsControlMode = attachmentsControlMode;
        }

        @Override
        public final Builder attachmentsControlMode(String attachmentsControlMode) {
            this.attachmentsControlMode = attachmentsControlMode;
            return this;
        }

        @Override
        public final Builder attachmentsControlMode(AttachmentsControlMode attachmentsControlMode) {
            this.attachmentsControlMode(attachmentsControlMode == null ? null : attachmentsControlMode.toString());
            return this;
        }

        @Override
        public AttachmentsConfiguration build() {
            return new AttachmentsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
