/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An authentication verification event response by a third party authentication server to Amazon Q Business.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AuthChallengeResponseEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthChallengeResponseEvent.Builder, AuthChallengeResponseEvent>, ChatInputStream {
    private static final SdkField<Map<String, String>> RESPONSE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseMap")
            .getter(getter(AuthChallengeResponseEvent::responseMap))
            .setter(setter(Builder::responseMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> responseMap;

    protected AuthChallengeResponseEvent(BuilderImpl builder) {
        this.responseMap = builder.responseMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseMap() {
        return responseMap != null && !(responseMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The mapping of key-value pairs in an authentication challenge response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseMap} method.
     * </p>
     * 
     * @return The mapping of key-value pairs in an authentication challenge response.
     */
    public final Map<String, String> responseMap() {
        return responseMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseMap() ? responseMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthChallengeResponseEvent)) {
            return false;
        }
        AuthChallengeResponseEvent other = (AuthChallengeResponseEvent) obj;
        return hasResponseMap() == other.hasResponseMap() && Objects.equals(responseMap(), other.responseMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthChallengeResponseEvent").add("ResponseMap", hasResponseMap() ? responseMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responseMap":
            return Optional.ofNullable(clazz.cast(responseMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final AuthChallengeResponseEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthChallengeResponseEvent, T> g) {
        return obj -> g.apply((AuthChallengeResponseEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthChallengeResponseEvent> {
        /**
         * <p>
         * The mapping of key-value pairs in an authentication challenge response.
         * </p>
         * 
         * @param responseMap
         *        The mapping of key-value pairs in an authentication challenge response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMap(Map<String, String> responseMap);
    }

    protected static class BuilderImpl implements Builder {
        private Map<String, String> responseMap = DefaultSdkAutoConstructMap.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(AuthChallengeResponseEvent model) {
            responseMap(model.responseMap);
        }

        public final Map<String, String> getResponseMap() {
            if (responseMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseMap;
        }

        public final void setResponseMap(Map<String, String> responseMap) {
            this.responseMap = AuthorizationResponseMapCopier.copy(responseMap);
        }

        @Override
        public final Builder responseMap(Map<String, String> responseMap) {
            this.responseMap = AuthorizationResponseMapCopier.copy(responseMap);
            return this;
        }

        @Override
        public AuthChallengeResponseEvent build() {
            return new AuthChallengeResponseEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
