/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for document attributes. Document attributes are metadata or fields associated with your
 * documents. For example, the company department name associated with each document.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html">Understanding document
 * attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeConfiguration.Builder, DocumentAttributeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DocumentAttributeConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DocumentAttributeConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SEARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("search")
            .getter(getter(DocumentAttributeConfiguration::searchAsString)).setter(setter(Builder::search))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("search").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            SEARCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String search;

    private DocumentAttributeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.search = builder.search;
    }

    /**
     * <p>
     * The name of the document attribute.
     * </p>
     * 
     * @return The name of the document attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of document attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document attribute.
     * @see AttributeType
     */
    public final AttributeType type() {
        return AttributeType.fromValue(type);
    }

    /**
     * <p>
     * The type of document attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document attribute.
     * @see AttributeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about whether the document attribute can be used by an end user to search for information on their
     * web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #search} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchAsString}.
     * </p>
     * 
     * @return Information about whether the document attribute can be used by an end user to search for information on
     *         their web experience.
     * @see Status
     */
    public final Status search() {
        return Status.fromValue(search);
    }

    /**
     * <p>
     * Information about whether the document attribute can be used by an end user to search for information on their
     * web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #search} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchAsString}.
     * </p>
     * 
     * @return Information about whether the document attribute can be used by an end user to search for information on
     *         their web experience.
     * @see Status
     */
    public final String searchAsString() {
        return search;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeConfiguration)) {
            return false;
        }
        DocumentAttributeConfiguration other = (DocumentAttributeConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(searchAsString(), other.searchAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeConfiguration").add("Name", name()).add("Type", typeAsString())
                .add("Search", searchAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "search":
            return Optional.ofNullable(clazz.cast(searchAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeConfiguration, T> g) {
        return obj -> g.apply((DocumentAttributeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeConfiguration> {
        /**
         * <p>
         * The name of the document attribute.
         * </p>
         * 
         * @param name
         *        The name of the document attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of document attribute.
         * </p>
         * 
         * @param type
         *        The type of document attribute.
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of document attribute.
         * </p>
         * 
         * @param type
         *        The type of document attribute.
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder type(AttributeType type);

        /**
         * <p>
         * Information about whether the document attribute can be used by an end user to search for information on
         * their web experience.
         * </p>
         * 
         * @param search
         *        Information about whether the document attribute can be used by an end user to search for information
         *        on their web experience.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder search(String search);

        /**
         * <p>
         * Information about whether the document attribute can be used by an end user to search for information on
         * their web experience.
         * </p>
         * 
         * @param search
         *        Information about whether the document attribute can be used by an end user to search for information
         *        on their web experience.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder search(Status search);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String search;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeConfiguration model) {
            name(model.name);
            type(model.type);
            search(model.search);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSearch() {
            return search;
        }

        public final void setSearch(String search) {
            this.search = search;
        }

        @Override
        public final Builder search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public final Builder search(Status search) {
            this.search(search == null ? null : search.toString());
            return this;
        }

        @Override
        public DocumentAttributeConfiguration build() {
            return new DocumentAttributeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
