/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRetrieverResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetRetrieverResponse.Builder, GetRetrieverResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetRetrieverResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverId").getter(getter(GetRetrieverResponse::retrieverId)).setter(setter(Builder::retrieverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()).build();

    private static final SdkField<String> RETRIEVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverArn").getter(getter(GetRetrieverResponse::retrieverArn)).setter(setter(Builder::retrieverArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetRetrieverResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetRetrieverResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetRetrieverResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<RetrieverConfiguration> CONFIGURATION_FIELD = SdkField
            .<RetrieverConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(GetRetrieverResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(RetrieverConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetRetrieverResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetRetrieverResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetRetrieverResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            RETRIEVER_ID_FIELD, RETRIEVER_ARN_FIELD, TYPE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD,
            ROLE_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private final String applicationId;

    private final String retrieverId;

    private final String retrieverArn;

    private final String type;

    private final String status;

    private final String displayName;

    private final RetrieverConfiguration configuration;

    private final String roleArn;

    private final Instant createdAt;

    private final Instant updatedAt;

    private GetRetrieverResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.retrieverId = builder.retrieverId;
        this.retrieverArn = builder.retrieverArn;
        this.type = builder.type;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application using the retriever.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application using the retriever.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the retriever.
     * </p>
     * 
     * @return The identifier of the retriever.
     */
    public final String retrieverId() {
        return retrieverId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
     */
    public final String retrieverArn() {
        return retrieverArn;
    }

    /**
     * <p>
     * The type of the retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the retriever.
     * @see RetrieverType
     */
    public final RetrieverType type() {
        return RetrieverType.fromValue(type);
    }

    /**
     * <p>
     * The type of the retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the retriever.
     * @see RetrieverType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrieverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retriever.
     * @see RetrieverStatus
     */
    public final RetrieverStatus status() {
        return RetrieverStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrieverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retriever.
     * @see RetrieverStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the retriever.
     * </p>
     * 
     * @return The name of the retriever.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the Configuration property for this object.
     * 
     * @return The value of the Configuration property for this object.
     */
    public final RetrieverConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with the permission to access the retriever and required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with the permission to access the retriever and required
     *         resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Unix timestamp when the retriever was created.
     * </p>
     * 
     * @return The Unix timestamp when the retriever was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the retriever was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the retriever was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(retrieverArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetrieverResponse)) {
            return false;
        }
        GetRetrieverResponse other = (GetRetrieverResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(retrieverId(), other.retrieverId())
                && Objects.equals(retrieverArn(), other.retrieverArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRetrieverResponse").add("ApplicationId", applicationId()).add("RetrieverId", retrieverId())
                .add("RetrieverArn", retrieverArn()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("DisplayName", displayName()).add("Configuration", configuration()).add("RoleArn", roleArn())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "retrieverId":
            return Optional.ofNullable(clazz.cast(retrieverId()));
        case "retrieverArn":
            return Optional.ofNullable(clazz.cast(retrieverArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRetrieverResponse, T> g) {
        return obj -> g.apply((GetRetrieverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRetrieverResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application using the retriever.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application using the retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the retriever.
         * </p>
         * 
         * @param retrieverId
         *        The identifier of the retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverId(String retrieverId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
         * </p>
         * 
         * @param retrieverArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverArn(String retrieverArn);

        /**
         * <p>
         * The type of the retriever.
         * </p>
         * 
         * @param type
         *        The type of the retriever.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the retriever.
         * </p>
         * 
         * @param type
         *        The type of the retriever.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(RetrieverType type);

        /**
         * <p>
         * The status of the retriever.
         * </p>
         * 
         * @param status
         *        The status of the retriever.
         * @see RetrieverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the retriever.
         * </p>
         * 
         * @param status
         *        The status of the retriever.
         * @see RetrieverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverStatus
         */
        Builder status(RetrieverStatus status);

        /**
         * <p>
         * The name of the retriever.
         * </p>
         * 
         * @param displayName
         *        The name of the retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * @param configuration
         *        The new value for the Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RetrieverConfiguration configuration);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrieverConfiguration.Builder} avoiding
         * the need to create one manually via {@link RetrieverConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieverConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(RetrieverConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RetrieverConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RetrieverConfiguration)
         */
        default Builder configuration(Consumer<RetrieverConfiguration.Builder> configuration) {
            return configuration(RetrieverConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with the permission to access the retriever and required
         * resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role with the permission to access the retriever and required
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Unix timestamp when the retriever was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the retriever was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the retriever was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the retriever was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String retrieverId;

        private String retrieverArn;

        private String type;

        private String status;

        private String displayName;

        private RetrieverConfiguration configuration;

        private String roleArn;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetrieverResponse model) {
            super(model);
            applicationId(model.applicationId);
            retrieverId(model.retrieverId);
            retrieverArn(model.retrieverArn);
            type(model.type);
            status(model.status);
            displayName(model.displayName);
            configuration(model.configuration);
            roleArn(model.roleArn);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRetrieverId() {
            return retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getRetrieverArn() {
            return retrieverArn;
        }

        public final void setRetrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
        }

        @Override
        public final Builder retrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrieverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final RetrieverConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RetrieverConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RetrieverConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetRetrieverResponse build() {
            return new GetRetrieverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
