/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores an Amazon Kendra index as a retriever.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KendraIndexConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KendraIndexConfiguration.Builder, KendraIndexConfiguration> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(KendraIndexConfiguration::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexId;

    private KendraIndexConfiguration(BuilderImpl builder) {
        this.indexId = builder.indexId;
    }

    /**
     * <p>
     * The identifier of the Amazon Kendra index.
     * </p>
     * 
     * @return The identifier of the Amazon Kendra index.
     */
    public final String indexId() {
        return indexId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KendraIndexConfiguration)) {
            return false;
        }
        KendraIndexConfiguration other = (KendraIndexConfiguration) obj;
        return Objects.equals(indexId(), other.indexId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KendraIndexConfiguration").add("IndexId", indexId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KendraIndexConfiguration, T> g) {
        return obj -> g.apply((KendraIndexConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KendraIndexConfiguration> {
        /**
         * <p>
         * The identifier of the Amazon Kendra index.
         * </p>
         * 
         * @param indexId
         *        The identifier of the Amazon Kendra index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);
    }

    static final class BuilderImpl implements Builder {
        private String indexId;

        private BuilderImpl() {
        }

        private BuilderImpl(KendraIndexConfiguration model) {
            indexId(model.indexId);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public KendraIndexConfiguration build() {
            return new KendraIndexConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
