/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A message in an Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(Message::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(Message::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("time")
            .getter(getter(Message::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Message::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<AttachmentOutput>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentOutput>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(Message::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTION_FIELD = SdkField
            .<List<SourceAttribution>> builder(MarshallingType.LIST)
            .memberName("sourceAttribution")
            .getter(getter(Message::sourceAttribution))
            .setter(setter(Builder::sourceAttribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttribution").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAttribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAttribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ActionReview> ACTION_REVIEW_FIELD = SdkField.<ActionReview> builder(MarshallingType.SDK_POJO)
            .memberName("actionReview").getter(getter(Message::actionReview)).setter(setter(Builder::actionReview))
            .constructor(ActionReview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReview").build()).build();

    private static final SdkField<ActionExecution> ACTION_EXECUTION_FIELD = SdkField
            .<ActionExecution> builder(MarshallingType.SDK_POJO).memberName("actionExecution")
            .getter(getter(Message::actionExecution)).setter(setter(Builder::actionExecution))
            .constructor(ActionExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, BODY_FIELD,
            TIME_FIELD, TYPE_FIELD, ATTACHMENTS_FIELD, SOURCE_ATTRIBUTION_FIELD, ACTION_REVIEW_FIELD, ACTION_EXECUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String body;

    private final Instant time;

    private final String type;

    private final List<AttachmentOutput> attachments;

    private final List<SourceAttribution> sourceAttribution;

    private final ActionReview actionReview;

    private final ActionExecution actionExecution;

    private Message(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.body = builder.body;
        this.time = builder.time;
        this.type = builder.type;
        this.attachments = builder.attachments;
        this.sourceAttribution = builder.sourceAttribution;
        this.actionReview = builder.actionReview;
        this.actionExecution = builder.actionExecution;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business web experience message.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business web experience message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The content of the Amazon Q Business web experience message.
     * </p>
     * 
     * @return The content of the Amazon Q Business web experience message.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The timestamp of the first Amazon Q Business web experience message.
     * </p>
     * 
     * @return The timestamp of the first Amazon Q Business web experience message.
     */
    public final Instant time() {
        return time;
    }

    /**
     * <p>
     * The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
     * @see MessageType
     */
    public final MessageType type() {
        return MessageType.fromValue(type);
    }

    /**
     * <p>
     * The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
     * @see MessageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A file directly uploaded into an Amazon Q Business web experience chat.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return A file directly uploaded into an Amazon Q Business web experience chat.
     */
    public final List<AttachmentOutput> attachments() {
        return attachments;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAttribution property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAttribution() {
        return sourceAttribution != null && !(sourceAttribution instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source documents used to generate Amazon Q Business web experience message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAttribution} method.
     * </p>
     * 
     * @return The source documents used to generate Amazon Q Business web experience message.
     */
    public final List<SourceAttribution> sourceAttribution() {
        return sourceAttribution;
    }

    /**
     * Returns the value of the ActionReview property for this object.
     * 
     * @return The value of the ActionReview property for this object.
     */
    public final ActionReview actionReview() {
        return actionReview;
    }

    /**
     * Returns the value of the ActionExecution property for this object.
     * 
     * @return The value of the ActionExecution property for this object.
     */
    public final ActionExecution actionExecution() {
        return actionExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAttribution() ? sourceAttribution() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actionReview());
        hashCode = 31 * hashCode + Objects.hashCode(actionExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(body(), other.body())
                && Objects.equals(time(), other.time()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && hasSourceAttribution() == other.hasSourceAttribution()
                && Objects.equals(sourceAttribution(), other.sourceAttribution())
                && Objects.equals(actionReview(), other.actionReview())
                && Objects.equals(actionExecution(), other.actionExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("MessageId", messageId()).add("Body", body()).add("Time", time())
                .add("Type", typeAsString()).add("Attachments", hasAttachments() ? attachments() : null)
                .add("SourceAttribution", hasSourceAttribution() ? sourceAttribution() : null)
                .add("ActionReview", actionReview()).add("ActionExecution", actionExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "time":
            return Optional.ofNullable(clazz.cast(time()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "sourceAttribution":
            return Optional.ofNullable(clazz.cast(sourceAttribution()));
        case "actionReview":
            return Optional.ofNullable(clazz.cast(actionReview()));
        case "actionExecution":
            return Optional.ofNullable(clazz.cast(actionExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The identifier of the Amazon Q Business web experience message.
         * </p>
         * 
         * @param messageId
         *        The identifier of the Amazon Q Business web experience message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The content of the Amazon Q Business web experience message.
         * </p>
         * 
         * @param body
         *        The content of the Amazon Q Business web experience message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The timestamp of the first Amazon Q Business web experience message.
         * </p>
         * 
         * @param time
         *        The timestamp of the first Amazon Q Business web experience message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
         * </p>
         * 
         * @param type
         *        The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
         * </p>
         * 
         * @param type
         *        The type of Amazon Q Business message, whether <code>HUMAN</code> or <code>AI</code> generated.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(MessageType type);

        /**
         * <p>
         * A file directly uploaded into an Amazon Q Business web experience chat.
         * </p>
         * 
         * @param attachments
         *        A file directly uploaded into an Amazon Q Business web experience chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentOutput> attachments);

        /**
         * <p>
         * A file directly uploaded into an Amazon Q Business web experience chat.
         * </p>
         * 
         * @param attachments
         *        A file directly uploaded into an Amazon Q Business web experience chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentOutput... attachments);

        /**
         * <p>
         * A file directly uploaded into an Amazon Q Business web experience chat.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<AttachmentOutput>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<AttachmentOutput>)
         */
        Builder attachments(Consumer<AttachmentOutput.Builder>... attachments);

        /**
         * <p>
         * The source documents used to generate Amazon Q Business web experience message.
         * </p>
         * 
         * @param sourceAttribution
         *        The source documents used to generate Amazon Q Business web experience message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttribution(Collection<SourceAttribution> sourceAttribution);

        /**
         * <p>
         * The source documents used to generate Amazon Q Business web experience message.
         * </p>
         * 
         * @param sourceAttribution
         *        The source documents used to generate Amazon Q Business web experience message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttribution(SourceAttribution... sourceAttribution);

        /**
         * <p>
         * The source documents used to generate Amazon Q Business web experience message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAttribution(List<SourceAttribution>)}.
         * 
         * @param sourceAttribution
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAttribution(java.util.Collection<SourceAttribution>)
         */
        Builder sourceAttribution(Consumer<SourceAttribution.Builder>... sourceAttribution);

        /**
         * Sets the value of the ActionReview property for this object.
         *
         * @param actionReview
         *        The new value for the ActionReview property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionReview(ActionReview actionReview);

        /**
         * Sets the value of the ActionReview property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionReview.Builder} avoiding the need
         * to create one manually via {@link ActionReview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionReview.Builder#build()} is called immediately and its
         * result is passed to {@link #actionReview(ActionReview)}.
         * 
         * @param actionReview
         *        a consumer that will call methods on {@link ActionReview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionReview(ActionReview)
         */
        default Builder actionReview(Consumer<ActionReview.Builder> actionReview) {
            return actionReview(ActionReview.builder().applyMutation(actionReview).build());
        }

        /**
         * Sets the value of the ActionExecution property for this object.
         *
         * @param actionExecution
         *        The new value for the ActionExecution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecution(ActionExecution actionExecution);

        /**
         * Sets the value of the ActionExecution property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionExecution.Builder} avoiding the
         * need to create one manually via {@link ActionExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #actionExecution(ActionExecution)}.
         * 
         * @param actionExecution
         *        a consumer that will call methods on {@link ActionExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionExecution(ActionExecution)
         */
        default Builder actionExecution(Consumer<ActionExecution.Builder> actionExecution) {
            return actionExecution(ActionExecution.builder().applyMutation(actionExecution).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String body;

        private Instant time;

        private String type;

        private List<AttachmentOutput> attachments = DefaultSdkAutoConstructList.getInstance();

        private List<SourceAttribution> sourceAttribution = DefaultSdkAutoConstructList.getInstance();

        private ActionReview actionReview;

        private ActionExecution actionExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            messageId(model.messageId);
            body(model.body);
            time(model.time);
            type(model.type);
            attachments(model.attachments);
            sourceAttribution(model.sourceAttribution);
            actionReview(model.actionReview);
            actionExecution(model.actionExecution);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Instant getTime() {
            return time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<AttachmentOutput.Builder> getAttachments() {
            List<AttachmentOutput.Builder> result = AttachmentsOutputCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentOutput.BuilderImpl> attachments) {
            this.attachments = AttachmentsOutputCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentOutput> attachments) {
            this.attachments = AttachmentsOutputCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentOutput... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentOutput.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttribution() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttribution);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttribution(Collection<SourceAttribution.BuilderImpl> sourceAttribution) {
            this.sourceAttribution = SourceAttributionsCopier.copyFromBuilder(sourceAttribution);
        }

        @Override
        public final Builder sourceAttribution(Collection<SourceAttribution> sourceAttribution) {
            this.sourceAttribution = SourceAttributionsCopier.copy(sourceAttribution);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttribution(SourceAttribution... sourceAttribution) {
            sourceAttribution(Arrays.asList(sourceAttribution));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttribution(Consumer<SourceAttribution.Builder>... sourceAttribution) {
            sourceAttribution(Stream.of(sourceAttribution).map(c -> SourceAttribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ActionReview.Builder getActionReview() {
            return actionReview != null ? actionReview.toBuilder() : null;
        }

        public final void setActionReview(ActionReview.BuilderImpl actionReview) {
            this.actionReview = actionReview != null ? actionReview.build() : null;
        }

        @Override
        public final Builder actionReview(ActionReview actionReview) {
            this.actionReview = actionReview;
            return this;
        }

        public final ActionExecution.Builder getActionExecution() {
            return actionExecution != null ? actionExecution.toBuilder() : null;
        }

        public final void setActionExecution(ActionExecution.BuilderImpl actionExecution) {
            this.actionExecution = actionExecution != null ? actionExecution.build() : null;
        }

        @Override
        public final Builder actionExecution(ActionExecution actionExecution) {
            this.actionExecution = actionExecution;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
