/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * End user feedback on an AI-generated web experience chat message usefulness.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageUsefulnessFeedback implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageUsefulnessFeedback.Builder, MessageUsefulnessFeedback> {
    private static final SdkField<String> USEFULNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usefulness").getter(getter(MessageUsefulnessFeedback::usefulnessAsString))
            .setter(setter(Builder::usefulness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usefulness").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(MessageUsefulnessFeedback::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(MessageUsefulnessFeedback::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Instant> SUBMITTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("submittedAt").getter(getter(MessageUsefulnessFeedback::submittedAt))
            .setter(setter(Builder::submittedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USEFULNESS_FIELD,
            REASON_FIELD, COMMENT_FIELD, SUBMITTED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String usefulness;

    private final String reason;

    private final String comment;

    private final Instant submittedAt;

    private MessageUsefulnessFeedback(BuilderImpl builder) {
        this.usefulness = builder.usefulness;
        this.reason = builder.reason;
        this.comment = builder.comment;
        this.submittedAt = builder.submittedAt;
    }

    /**
     * <p>
     * The usefulness value assigned by an end user to a message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link MessageUsefulness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return The usefulness value assigned by an end user to a message.
     * @see MessageUsefulness
     */
    public final MessageUsefulness usefulness() {
        return MessageUsefulness.fromValue(usefulness);
    }

    /**
     * <p>
     * The usefulness value assigned by an end user to a message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link MessageUsefulness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return The usefulness value assigned by an end user to a message.
     * @see MessageUsefulness
     */
    public final String usefulnessAsString() {
        return usefulness;
    }

    /**
     * <p>
     * The reason for a usefulness rating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link MessageUsefulnessReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for a usefulness rating.
     * @see MessageUsefulnessReason
     */
    public final MessageUsefulnessReason reason() {
        return MessageUsefulnessReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for a usefulness rating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link MessageUsefulnessReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for a usefulness rating.
     * @see MessageUsefulnessReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * A comment given by an end user on the usefulness of an AI-generated chat message.
     * </p>
     * 
     * @return A comment given by an end user on the usefulness of an AI-generated chat message.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The timestamp for when the feedback was submitted.
     * </p>
     * 
     * @return The timestamp for when the feedback was submitted.
     */
    public final Instant submittedAt() {
        return submittedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usefulnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageUsefulnessFeedback)) {
            return false;
        }
        MessageUsefulnessFeedback other = (MessageUsefulnessFeedback) obj;
        return Objects.equals(usefulnessAsString(), other.usefulnessAsString())
                && Objects.equals(reasonAsString(), other.reasonAsString()) && Objects.equals(comment(), other.comment())
                && Objects.equals(submittedAt(), other.submittedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageUsefulnessFeedback").add("Usefulness", usefulnessAsString())
                .add("Reason", reasonAsString()).add("Comment", comment()).add("SubmittedAt", submittedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usefulness":
            return Optional.ofNullable(clazz.cast(usefulnessAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "submittedAt":
            return Optional.ofNullable(clazz.cast(submittedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageUsefulnessFeedback, T> g) {
        return obj -> g.apply((MessageUsefulnessFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageUsefulnessFeedback> {
        /**
         * <p>
         * The usefulness value assigned by an end user to a message.
         * </p>
         * 
         * @param usefulness
         *        The usefulness value assigned by an end user to a message.
         * @see MessageUsefulness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageUsefulness
         */
        Builder usefulness(String usefulness);

        /**
         * <p>
         * The usefulness value assigned by an end user to a message.
         * </p>
         * 
         * @param usefulness
         *        The usefulness value assigned by an end user to a message.
         * @see MessageUsefulness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageUsefulness
         */
        Builder usefulness(MessageUsefulness usefulness);

        /**
         * <p>
         * The reason for a usefulness rating.
         * </p>
         * 
         * @param reason
         *        The reason for a usefulness rating.
         * @see MessageUsefulnessReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageUsefulnessReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for a usefulness rating.
         * </p>
         * 
         * @param reason
         *        The reason for a usefulness rating.
         * @see MessageUsefulnessReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageUsefulnessReason
         */
        Builder reason(MessageUsefulnessReason reason);

        /**
         * <p>
         * A comment given by an end user on the usefulness of an AI-generated chat message.
         * </p>
         * 
         * @param comment
         *        A comment given by an end user on the usefulness of an AI-generated chat message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The timestamp for when the feedback was submitted.
         * </p>
         * 
         * @param submittedAt
         *        The timestamp for when the feedback was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);
    }

    static final class BuilderImpl implements Builder {
        private String usefulness;

        private String reason;

        private String comment;

        private Instant submittedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageUsefulnessFeedback model) {
            usefulness(model.usefulness);
            reason(model.reason);
            comment(model.comment);
            submittedAt(model.submittedAt);
        }

        public final String getUsefulness() {
            return usefulness;
        }

        public final void setUsefulness(String usefulness) {
            this.usefulness = usefulness;
        }

        @Override
        public final Builder usefulness(String usefulness) {
            this.usefulness = usefulness;
            return this;
        }

        @Override
        public final Builder usefulness(MessageUsefulness usefulness) {
            this.usefulness(usefulness == null ? null : usefulness.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(MessageUsefulnessReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        @Override
        public MessageUsefulnessFeedback build() {
            return new MessageUsefulnessFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
