/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides user and group information used for filtering documents to use for generating Amazon Q Business conversation
 * responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Principal implements SdkPojo, Serializable, ToCopyableBuilder<Principal.Builder, Principal> {
    private static final SdkField<PrincipalUser> USER_FIELD = SdkField.<PrincipalUser> builder(MarshallingType.SDK_POJO)
            .memberName("user").getter(getter(Principal::user)).setter(setter(Builder::user)).constructor(PrincipalUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<PrincipalGroup> GROUP_FIELD = SdkField.<PrincipalGroup> builder(MarshallingType.SDK_POJO)
            .memberName("group").getter(getter(Principal::group)).setter(setter(Builder::group))
            .constructor(PrincipalGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final PrincipalUser user;

    private final PrincipalGroup group;

    private final Type type;

    private Principal(BuilderImpl builder) {
        this.user = builder.user;
        this.group = builder.group;
        this.type = builder.type;
    }

    /**
     * <p>
     * The user associated with the principal.
     * </p>
     * 
     * @return The user associated with the principal.
     */
    public final PrincipalUser user() {
        return user;
    }

    /**
     * <p>
     * The group associated with the principal.
     * </p>
     * 
     * @return The group associated with the principal.
     */
    public final PrincipalGroup group() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(group(), other.group());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Principal").add("User", user()).add("Group", group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The user associated with the principal.
     * </p>
     * 
     * @param user
     *        The user associated with the principal.
     */
    public static Principal fromUser(PrincipalUser user) {
        return builder().user(user).build();
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The user associated with the principal.
     * </p>
     * 
     * @param user
     *        The user associated with the principal.
     */
    public static Principal fromUser(Consumer<PrincipalUser.Builder> user) {
        PrincipalUser.Builder builder = PrincipalUser.builder();
        user.accept(builder);
        return fromUser(builder.build());
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The group associated with the principal.
     * </p>
     * 
     * @param group
     *        The group associated with the principal.
     */
    public static Principal fromGroup(PrincipalGroup group) {
        return builder().group(group).build();
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The group associated with the principal.
     * </p>
     * 
     * @param group
     *        The group associated with the principal.
     */
    public static Principal fromGroup(Consumer<PrincipalGroup.Builder> group) {
        PrincipalGroup.Builder builder = PrincipalGroup.builder();
        group.accept(builder);
        return fromGroup(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Principal> {
        /**
         * <p>
         * The user associated with the principal.
         * </p>
         * 
         * @param user
         *        The user associated with the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(PrincipalUser user);

        /**
         * <p>
         * The user associated with the principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrincipalUser.Builder} avoiding the need
         * to create one manually via {@link PrincipalUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrincipalUser.Builder#build()} is called immediately and its
         * result is passed to {@link #user(PrincipalUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link PrincipalUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(PrincipalUser)
         */
        default Builder user(Consumer<PrincipalUser.Builder> user) {
            return user(PrincipalUser.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * The group associated with the principal.
         * </p>
         * 
         * @param group
         *        The group associated with the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(PrincipalGroup group);

        /**
         * <p>
         * The group associated with the principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrincipalGroup.Builder} avoiding the need
         * to create one manually via {@link PrincipalGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrincipalGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #group(PrincipalGroup)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link PrincipalGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(PrincipalGroup)
         */
        default Builder group(Consumer<PrincipalGroup.Builder> group) {
            return group(PrincipalGroup.builder().applyMutation(group).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrincipalUser user;

        private PrincipalGroup group;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            user(model.user);
            group(model.group);
        }

        public final PrincipalUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(PrincipalUser.BuilderImpl user) {
            Object oldValue = this.user;
            this.user = user != null ? user.build() : null;
            handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(PrincipalUser user) {
            Object oldValue = this.user;
            this.user = user;
            handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        public final PrincipalGroup.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(PrincipalGroup.BuilderImpl group) {
            Object oldValue = this.group;
            this.group = group != null ? group.build() : null;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(PrincipalGroup group) {
            Object oldValue = this.group;
            this.group = group;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        @Override
        public Principal build() {
            return new Principal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Principal#type()
     */
    public enum Type {
        USER,

        GROUP,

        UNKNOWN_TO_SDK_VERSION
    }
}
