/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about Amazon Q Apps. (preview feature)
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QAppsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QAppsConfiguration.Builder, QAppsConfiguration> {
    private static final SdkField<String> Q_APPS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("qAppsControlMode").getter(getter(QAppsConfiguration::qAppsControlModeAsString))
            .setter(setter(Builder::qAppsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsControlMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(Q_APPS_CONTROL_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String qAppsControlMode;

    private QAppsConfiguration(BuilderImpl builder) {
        this.qAppsControlMode = builder.qAppsControlMode;
    }

    /**
     * <p>
     * Status information about whether end users can create and use Amazon Q Apps in the web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qAppsControlMode}
     * will return {@link QAppsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #qAppsControlModeAsString}.
     * </p>
     * 
     * @return Status information about whether end users can create and use Amazon Q Apps in the web experience.
     * @see QAppsControlMode
     */
    public final QAppsControlMode qAppsControlMode() {
        return QAppsControlMode.fromValue(qAppsControlMode);
    }

    /**
     * <p>
     * Status information about whether end users can create and use Amazon Q Apps in the web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qAppsControlMode}
     * will return {@link QAppsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #qAppsControlModeAsString}.
     * </p>
     * 
     * @return Status information about whether end users can create and use Amazon Q Apps in the web experience.
     * @see QAppsControlMode
     */
    public final String qAppsControlModeAsString() {
        return qAppsControlMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qAppsControlModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QAppsConfiguration)) {
            return false;
        }
        QAppsConfiguration other = (QAppsConfiguration) obj;
        return Objects.equals(qAppsControlModeAsString(), other.qAppsControlModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QAppsConfiguration").add("QAppsControlMode", qAppsControlModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "qAppsControlMode":
            return Optional.ofNullable(clazz.cast(qAppsControlModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QAppsConfiguration, T> g) {
        return obj -> g.apply((QAppsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QAppsConfiguration> {
        /**
         * <p>
         * Status information about whether end users can create and use Amazon Q Apps in the web experience.
         * </p>
         * 
         * @param qAppsControlMode
         *        Status information about whether end users can create and use Amazon Q Apps in the web experience.
         * @see QAppsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QAppsControlMode
         */
        Builder qAppsControlMode(String qAppsControlMode);

        /**
         * <p>
         * Status information about whether end users can create and use Amazon Q Apps in the web experience.
         * </p>
         * 
         * @param qAppsControlMode
         *        Status information about whether end users can create and use Amazon Q Apps in the web experience.
         * @see QAppsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QAppsControlMode
         */
        Builder qAppsControlMode(QAppsControlMode qAppsControlMode);
    }

    static final class BuilderImpl implements Builder {
        private String qAppsControlMode;

        private BuilderImpl() {
        }

        private BuilderImpl(QAppsConfiguration model) {
            qAppsControlMode(model.qAppsControlMode);
        }

        public final String getQAppsControlMode() {
            return qAppsControlMode;
        }

        public final void setQAppsControlMode(String qAppsControlMode) {
            this.qAppsControlMode = qAppsControlMode;
        }

        @Override
        public final Builder qAppsControlMode(String qAppsControlMode) {
            this.qAppsControlMode = qAppsControlMode;
            return this;
        }

        @Override
        public final Builder qAppsControlMode(QAppsControlMode qAppsControlMode) {
            this.qAppsControlMode(qAppsControlMode == null ? null : qAppsControlMode.toString());
            return this;
        }

        @Override
        public QAppsConfiguration build() {
            return new QAppsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
