/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An input event for a end user message in an Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TextInputEvent implements SdkPojo, Serializable, ToCopyableBuilder<TextInputEvent.Builder, TextInputEvent>,
        ChatInputStream {
    private static final SdkField<String> USER_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessage").getter(getter(TextInputEvent::userMessage)).setter(setter(Builder::userMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userMessage;

    protected TextInputEvent(BuilderImpl builder) {
        this.userMessage = builder.userMessage;
    }

    /**
     * <p>
     * A user message in a text message input event.
     * </p>
     * 
     * @return A user message in a text message input event.
     */
    public final String userMessage() {
        return userMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputEvent)) {
            return false;
        }
        TextInputEvent other = (TextInputEvent) obj;
        return Objects.equals(userMessage(), other.userMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextInputEvent").add("UserMessage", userMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userMessage":
            return Optional.ofNullable(clazz.cast(userMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TextInputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextInputEvent, T> g) {
        return obj -> g.apply((TextInputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextInputEvent> {
        /**
         * <p>
         * A user message in a text message input event.
         * </p>
         * 
         * @param userMessage
         *        A user message in a text message input event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessage(String userMessage);
    }

    protected static class BuilderImpl implements Builder {
        private String userMessage;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TextInputEvent model) {
            userMessage(model.userMessage);
        }

        public final String getUserMessage() {
            return userMessage;
        }

        public final void setUserMessage(String userMessage) {
            this.userMessage = userMessage;
        }

        @Override
        public final Builder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        @Override
        public TextInputEvent build() {
            return new TextInputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
