/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user
 * management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoSubscriptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoSubscriptionConfiguration.Builder, AutoSubscriptionConfiguration> {
    private static final SdkField<String> AUTO_SUBSCRIBE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoSubscribe").getter(getter(AutoSubscriptionConfiguration::autoSubscribeAsString))
            .setter(setter(Builder::autoSubscribe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubscribe").build()).build();

    private static final SdkField<String> DEFAULT_SUBSCRIPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultSubscriptionType").getter(getter(AutoSubscriptionConfiguration::defaultSubscriptionTypeAsString))
            .setter(setter(Builder::defaultSubscriptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSubscriptionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SUBSCRIBE_FIELD,
            DEFAULT_SUBSCRIPTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoSubscribe;

    private final String defaultSubscriptionType;

    private AutoSubscriptionConfiguration(BuilderImpl builder) {
        this.autoSubscribe = builder.autoSubscribe;
        this.defaultSubscriptionType = builder.defaultSubscriptionType;
    }

    /**
     * <p>
     * Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity
     * federation for user management.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoSubscribe}
     * will return {@link AutoSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoSubscribeAsString}.
     * </p>
     * 
     * @return Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM
     *         identity federation for user management.
     * @see AutoSubscriptionStatus
     */
    public final AutoSubscriptionStatus autoSubscribe() {
        return AutoSubscriptionStatus.fromValue(autoSubscribe);
    }

    /**
     * <p>
     * Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity
     * federation for user management.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoSubscribe}
     * will return {@link AutoSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoSubscribeAsString}.
     * </p>
     * 
     * @return Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM
     *         identity federation for user management.
     * @see AutoSubscriptionStatus
     */
    public final String autoSubscribeAsString() {
        return autoSubscribe;
    }

    /**
     * <p>
     * Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
     * federation for user management. If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code> you
     * must select a value for this field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSubscriptionType} will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSubscriptionTypeAsString}.
     * </p>
     * 
     * @return Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
     *         federation for user management. If the value for <code>autoSubscribe</code> is set to
     *         <code>ENABLED</code> you must select a value for this field.
     * @see SubscriptionType
     */
    public final SubscriptionType defaultSubscriptionType() {
        return SubscriptionType.fromValue(defaultSubscriptionType);
    }

    /**
     * <p>
     * Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
     * federation for user management. If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code> you
     * must select a value for this field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSubscriptionType} will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSubscriptionTypeAsString}.
     * </p>
     * 
     * @return Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
     *         federation for user management. If the value for <code>autoSubscribe</code> is set to
     *         <code>ENABLED</code> you must select a value for this field.
     * @see SubscriptionType
     */
    public final String defaultSubscriptionTypeAsString() {
        return defaultSubscriptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoSubscribeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubscriptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoSubscriptionConfiguration)) {
            return false;
        }
        AutoSubscriptionConfiguration other = (AutoSubscriptionConfiguration) obj;
        return Objects.equals(autoSubscribeAsString(), other.autoSubscribeAsString())
                && Objects.equals(defaultSubscriptionTypeAsString(), other.defaultSubscriptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoSubscriptionConfiguration").add("AutoSubscribe", autoSubscribeAsString())
                .add("DefaultSubscriptionType", defaultSubscriptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoSubscribe":
            return Optional.ofNullable(clazz.cast(autoSubscribeAsString()));
        case "defaultSubscriptionType":
            return Optional.ofNullable(clazz.cast(defaultSubscriptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoSubscriptionConfiguration, T> g) {
        return obj -> g.apply((AutoSubscriptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoSubscriptionConfiguration> {
        /**
         * <p>
         * Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity
         * federation for user management.
         * </p>
         * 
         * @param autoSubscribe
         *        Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM
         *        identity federation for user management.
         * @see AutoSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoSubscriptionStatus
         */
        Builder autoSubscribe(String autoSubscribe);

        /**
         * <p>
         * Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity
         * federation for user management.
         * </p>
         * 
         * @param autoSubscribe
         *        Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM
         *        identity federation for user management.
         * @see AutoSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoSubscriptionStatus
         */
        Builder autoSubscribe(AutoSubscriptionStatus autoSubscribe);

        /**
         * <p>
         * Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
         * federation for user management. If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code>
         * you must select a value for this field.
         * </p>
         * 
         * @param defaultSubscriptionType
         *        Describes the default subscription type assigned to an Amazon Q Business application using IAM
         *        identity federation for user management. If the value for <code>autoSubscribe</code> is set to
         *        <code>ENABLED</code> you must select a value for this field.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder defaultSubscriptionType(String defaultSubscriptionType);

        /**
         * <p>
         * Describes the default subscription type assigned to an Amazon Q Business application using IAM identity
         * federation for user management. If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code>
         * you must select a value for this field.
         * </p>
         * 
         * @param defaultSubscriptionType
         *        Describes the default subscription type assigned to an Amazon Q Business application using IAM
         *        identity federation for user management. If the value for <code>autoSubscribe</code> is set to
         *        <code>ENABLED</code> you must select a value for this field.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder defaultSubscriptionType(SubscriptionType defaultSubscriptionType);
    }

    static final class BuilderImpl implements Builder {
        private String autoSubscribe;

        private String defaultSubscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoSubscriptionConfiguration model) {
            autoSubscribe(model.autoSubscribe);
            defaultSubscriptionType(model.defaultSubscriptionType);
        }

        public final String getAutoSubscribe() {
            return autoSubscribe;
        }

        public final void setAutoSubscribe(String autoSubscribe) {
            this.autoSubscribe = autoSubscribe;
        }

        @Override
        public final Builder autoSubscribe(String autoSubscribe) {
            this.autoSubscribe = autoSubscribe;
            return this;
        }

        @Override
        public final Builder autoSubscribe(AutoSubscriptionStatus autoSubscribe) {
            this.autoSubscribe(autoSubscribe == null ? null : autoSubscribe.toString());
            return this;
        }

        public final String getDefaultSubscriptionType() {
            return defaultSubscriptionType;
        }

        public final void setDefaultSubscriptionType(String defaultSubscriptionType) {
            this.defaultSubscriptionType = defaultSubscriptionType;
        }

        @Override
        public final Builder defaultSubscriptionType(String defaultSubscriptionType) {
            this.defaultSubscriptionType = defaultSubscriptionType;
            return this;
        }

        @Override
        public final Builder defaultSubscriptionType(SubscriptionType defaultSubscriptionType) {
            this.defaultSubscriptionType(defaultSubscriptionType == null ? null : defaultSubscriptionType.toString());
            return this;
        }

        @Override
        public AutoSubscriptionConfiguration build() {
            return new AutoSubscriptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
