/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;

/**
 * Response handler for the Chat API.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface ChatResponseHandler extends EventStreamResponseHandler<ChatResponse, ChatOutputStream> {
    /**
     * Create a {@link Builder}, used to create a {@link ChatResponseHandler}.
     */
    static Builder builder() {
        return new DefaultChatResponseHandlerBuilder();
    }

    /**
     * Builder for {@link ChatResponseHandler}. This can be used to create the {@link ChatResponseHandler} in a more
     * functional way, you may also directly implement the {@link ChatResponseHandler} interface if preferred.
     */
    @Generated("software.amazon.awssdk:codegen")
    interface Builder extends EventStreamResponseHandler.Builder<ChatResponse, ChatOutputStream, Builder> {
        /**
         * Sets the subscriber to the {@link org.reactivestreams.Publisher} of events. The given {@link Visitor} will be
         * called for each event received by the publisher. Events are requested sequentially after each event is
         * processed. If you need more control over the backpressure strategy consider using
         * {@link #subscriber(java.util.function.Supplier)} instead.
         *
         * @param visitor
         *        Visitor that will be invoked for each incoming event.
         * @return This builder for method chaining
         */
        Builder subscriber(Visitor visitor);

        /**
         * @return A {@link ChatResponseHandler} implementation that can be used in the Chat API call.
         */
        ChatResponseHandler build();
    }

    /**
     * Visitor for subtypes of {@link ChatOutputStream}.
     */
    @Generated("software.amazon.awssdk:codegen")
    interface Visitor {
        /**
         * @return A new {@link Builder}.
         */
        static Builder builder() {
            return new DefaultChatVisitorBuilder();
        }

        /**
         * A required "else" or "default" block, invoked when no other more-specific "visit" method is appropriate. This
         * is invoked under two circumstances:
         * <ol>
         * <li>The event encountered is newer than the current version of the SDK, so no other more-specific "visit"
         * method could be called. In this case, the provided event will be a generic {@link ChatOutputStream}. These
         * events can be processed by upgrading the SDK.</li>
         * <li>The event is known by the SDK, but the "visit" was not overridden above. In this case, the provided event
         * will be a specific type of {@link ChatOutputStream}.</li>
         * </ol>
         *
         * @param event
         *        The event that was not handled by a more-specific "visit" method.
         */
        default void visitDefault(ChatOutputStream event) {
        }

        /**
         * Invoked when a {@link TextOutputEvent} is encountered. If this is not overridden, the event will be given to
         * {@link #visitDefault(ChatOutputStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitTextEvent(TextOutputEvent event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link MetadataEvent} is encountered. If this is not overridden, the event will be given to
         * {@link #visitDefault(ChatOutputStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitMetadataEvent(MetadataEvent event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link ActionReviewEvent} is encountered. If this is not overridden, the event will be given
         * to {@link #visitDefault(ChatOutputStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitActionReviewEvent(ActionReviewEvent event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link FailedAttachmentEvent} is encountered. If this is not overridden, the event will be
         * given to {@link #visitDefault(ChatOutputStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitFailedAttachmentEvent(FailedAttachmentEvent event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link AuthChallengeRequestEvent} is encountered. If this is not overridden, the event will be
         * given to {@link #visitDefault(ChatOutputStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitAuthChallengeRequestEvent(AuthChallengeRequestEvent event) {
            visitDefault(event);
        }

        /**
         * Builder for {@link Visitor}. The {@link Visitor} class may also be extended for a more traditional style but
         * this builder allows for a more functional way of creating a visitor will callback methods.
         */
        @Generated("software.amazon.awssdk:codegen")
        interface Builder {
            /**
             * Callback to invoke when either an unknown event is visited or an unhandled event is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onDefault(Consumer<ChatOutputStream> c);

            /**
             * @return Visitor implementation.
             */
            Visitor build();

            /**
             * Callback to invoke when a {@link TextOutputEvent} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onTextEvent(Consumer<TextOutputEvent> c);

            /**
             * Callback to invoke when a {@link MetadataEvent} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onMetadataEvent(Consumer<MetadataEvent> c);

            /**
             * Callback to invoke when a {@link ActionReviewEvent} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onActionReviewEvent(Consumer<ActionReviewEvent> c);

            /**
             * Callback to invoke when a {@link FailedAttachmentEvent} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onFailedAttachmentEvent(Consumer<FailedAttachmentEvent> c);

            /**
             * Callback to invoke when a {@link AuthChallengeRequestEvent} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onAuthChallengeRequestEvent(Consumer<AuthChallengeRequestEvent> c);
        }
    }
}
