/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Q Business.
 * </p>
 * <p>
 * For example, you can delete all customer identification numbers associated with the documents, stored in the document
 * metadata field called 'Customer_ID' by setting the target key as 'Customer_ID' and the deletion flag to
 * <code>TRUE</code>. This removes all customer ID values in the field 'Customer_ID'. This would scrub personally
 * identifiable information from each document's metadata.
 * </p>
 * <p>
 * Amazon Q Business can't create a target field if it has not already been created as an index field. After you create
 * your index field, you can create a document metadata field using <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html">
 * <code>DocumentAttributeTarget</code> </a>. Amazon Q Business will then map your newly created document attribute to
 * your index field.
 * </p>
 * <p>
 * You can also use this with <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html">
 * <code>DocumentAttributeCondition</code> </a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeTarget.Builder, DocumentAttributeTarget> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(DocumentAttributeTarget::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<DocumentAttributeValue> VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(DocumentAttributeTarget::value)).setter(setter(Builder::value))
            .constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeValueOperator").getter(getter(DocumentAttributeTarget::attributeValueOperatorAsString))
            .setter(setter(Builder::attributeValueOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValueOperator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            ATTRIBUTE_VALUE_OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final DocumentAttributeValue value;

    private final String attributeValueOperator;

    private DocumentAttributeTarget(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.attributeValueOperator = builder.attributeValueOperator;
    }

    /**
     * <p>
     * The identifier of the target document attribute or metadata field. For example, 'Department' could be an
     * identifier for the target attribute or metadata field that includes the department names associated with the
     * documents.
     * </p>
     * 
     * @return The identifier of the target document attribute or metadata field. For example, 'Department' could be an
     *         identifier for the target attribute or metadata field that includes the department names associated with
     *         the documents.
     */
    public final String key() {
        return key;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final DocumentAttributeValue value() {
        return value;
    }

    /**
     * <p>
     * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot create
     * a target value and set this to <code>TRUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeValueOperator} will return {@link AttributeValueOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeValueOperatorAsString}.
     * </p>
     * 
     * @return <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
     *         create a target value and set this to <code>TRUE</code>.
     * @see AttributeValueOperator
     */
    public final AttributeValueOperator attributeValueOperator() {
        return AttributeValueOperator.fromValue(attributeValueOperator);
    }

    /**
     * <p>
     * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot create
     * a target value and set this to <code>TRUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeValueOperator} will return {@link AttributeValueOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeValueOperatorAsString}.
     * </p>
     * 
     * @return <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
     *         create a target value and set this to <code>TRUE</code>.
     * @see AttributeValueOperator
     */
    public final String attributeValueOperatorAsString() {
        return attributeValueOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValueOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeTarget)) {
            return false;
        }
        DocumentAttributeTarget other = (DocumentAttributeTarget) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(attributeValueOperatorAsString(), other.attributeValueOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeTarget").add("Key", key()).add("Value", value())
                .add("AttributeValueOperator", attributeValueOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "attributeValueOperator":
            return Optional.ofNullable(clazz.cast(attributeValueOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeTarget, T> g) {
        return obj -> g.apply((DocumentAttributeTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeTarget> {
        /**
         * <p>
         * The identifier of the target document attribute or metadata field. For example, 'Department' could be an
         * identifier for the target attribute or metadata field that includes the department names associated with the
         * documents.
         * </p>
         * 
         * @param key
         *        The identifier of the target document attribute or metadata field. For example, 'Department' could be
         *        an identifier for the target attribute or metadata field that includes the department names associated
         *        with the documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DocumentAttributeValue value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(DocumentAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DocumentAttributeValue)
         */
        default Builder value(Consumer<DocumentAttributeValue.Builder> value) {
            return value(DocumentAttributeValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
         * create a target value and set this to <code>TRUE</code>.
         * </p>
         * 
         * @param attributeValueOperator
         *        <code>TRUE</code> to delete the existing target value for your specified target attribute key. You
         *        cannot create a target value and set this to <code>TRUE</code>.
         * @see AttributeValueOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeValueOperator
         */
        Builder attributeValueOperator(String attributeValueOperator);

        /**
         * <p>
         * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
         * create a target value and set this to <code>TRUE</code>.
         * </p>
         * 
         * @param attributeValueOperator
         *        <code>TRUE</code> to delete the existing target value for your specified target attribute key. You
         *        cannot create a target value and set this to <code>TRUE</code>.
         * @see AttributeValueOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeValueOperator
         */
        Builder attributeValueOperator(AttributeValueOperator attributeValueOperator);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private DocumentAttributeValue value;

        private String attributeValueOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeTarget model) {
            key(model.key);
            value(model.value);
            attributeValueOperator(model.attributeValueOperator);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final DocumentAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DocumentAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DocumentAttributeValue value) {
            this.value = value;
            return this;
        }

        public final String getAttributeValueOperator() {
            return attributeValueOperator;
        }

        public final void setAttributeValueOperator(String attributeValueOperator) {
            this.attributeValueOperator = attributeValueOperator;
        }

        @Override
        public final Builder attributeValueOperator(String attributeValueOperator) {
            this.attributeValueOperator = attributeValueOperator;
            return this;
        }

        @Override
        public final Builder attributeValueOperator(AttributeValueOperator attributeValueOperator) {
            this.attributeValueOperator(attributeValueOperator == null ? null : attributeValueOperator.toString());
            return this;
        }

        @Override
        public DocumentAttributeTarget build() {
            return new DocumentAttributeTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
