/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contents of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentContent implements SdkPojo, Serializable, ToCopyableBuilder<DocumentContent.Builder, DocumentContent> {
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("blob").getter(getter(DocumentContent::blob)).setter(setter(Builder::blob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()).build();

    private static final SdkField<S3> S3_FIELD = SdkField.<S3> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(DocumentContent::s3)).setter(setter(Builder::s3)).constructor(S3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_FIELD, S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes blob;

    private final S3 s3;

    private final Type type;

    private DocumentContent(BuilderImpl builder) {
        this.blob = builder.blob;
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    /**
     * <p>
     * The contents of the document. Documents passed to the <code>blob</code> parameter must be base64 encoded. Your
     * code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call Amazon Q
     * Business APIs. If you are calling the Amazon Q Business endpoint directly using REST, you must base64 encode the
     * contents before sending.
     * </p>
     * 
     * @return The contents of the document. Documents passed to the <code>blob</code> parameter must be base64 encoded.
     *         Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to
     *         call Amazon Q Business APIs. If you are calling the Amazon Q Business endpoint directly using REST, you
     *         must base64 encode the contents before sending.
     */
    public final SdkBytes blob() {
        return blob;
    }

    /**
     * <p>
     * The path to the document in an Amazon S3 bucket.
     * </p>
     * 
     * @return The path to the document in an Amazon S3 bucket.
     */
    public final S3 s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blob());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentContent)) {
            return false;
        }
        DocumentContent other = (DocumentContent) obj;
        return Objects.equals(blob(), other.blob()) && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentContent").add("Blob", blob()).add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blob":
            return Optional.ofNullable(clazz.cast(blob()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #blob()} initialized to the given value.
     *
     * <p>
     * The contents of the document. Documents passed to the <code>blob</code> parameter must be base64 encoded. Your
     * code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call Amazon Q
     * Business APIs. If you are calling the Amazon Q Business endpoint directly using REST, you must base64 encode the
     * contents before sending.
     * </p>
     * 
     * @param blob
     *        The contents of the document. Documents passed to the <code>blob</code> parameter must be base64 encoded.
     *        Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to
     *        call Amazon Q Business APIs. If you are calling the Amazon Q Business endpoint directly using REST, you
     *        must base64 encode the contents before sending.
     */
    public static DocumentContent fromBlob(SdkBytes blob) {
        return builder().blob(blob).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * The path to the document in an Amazon S3 bucket.
     * </p>
     * 
     * @param s3
     *        The path to the document in an Amazon S3 bucket.
     */
    public static DocumentContent fromS3(S3 s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * The path to the document in an Amazon S3 bucket.
     * </p>
     * 
     * @param s3
     *        The path to the document in an Amazon S3 bucket.
     */
    public static DocumentContent fromS3(Consumer<S3.Builder> s3) {
        S3.Builder builder = S3.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentContent, T> g) {
        return obj -> g.apply((DocumentContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentContent> {
        /**
         * <p>
         * The contents of the document. Documents passed to the <code>blob</code> parameter must be base64 encoded.
         * Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call
         * Amazon Q Business APIs. If you are calling the Amazon Q Business endpoint directly using REST, you must
         * base64 encode the contents before sending.
         * </p>
         * 
         * @param blob
         *        The contents of the document. Documents passed to the <code>blob</code> parameter must be base64
         *        encoded. Your code might not need to encode the document file bytes if you're using an Amazon Web
         *        Services SDK to call Amazon Q Business APIs. If you are calling the Amazon Q Business endpoint
         *        directly using REST, you must base64 encode the contents before sending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blob(SdkBytes blob);

        /**
         * <p>
         * The path to the document in an Amazon S3 bucket.
         * </p>
         * 
         * @param s3
         *        The path to the document in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3 s3);

        /**
         * <p>
         * The path to the document in an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3.Builder} avoiding the need to create
         * one manually via {@link S3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3.Builder#build()} is called immediately and its result is
         * passed to {@link #s3(S3)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3)
         */
        default Builder s3(Consumer<S3.Builder> s3) {
            return s3(S3.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes blob;

        private S3 s3;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentContent model) {
            blob(model.blob);
            s3(model.s3);
        }

        public final ByteBuffer getBlob() {
            return blob == null ? null : blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            blob(blob == null ? null : SdkBytes.fromByteBuffer(blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            Object oldValue = this.blob;
            this.blob = blob;
            handleUnionValueChange(Type.BLOB, oldValue, this.blob);
            return this;
        }

        public final S3.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3 s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        public DocumentContent build() {
            return new DocumentContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DocumentContent#type()
     */
    public enum Type {
        BLOB,

        S3,

        UNKNOWN_TO_SDK_VERSION
    }
}
