/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model.chatoutputstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.MetadataEvent;

/**
 * A specialization of {@code software.amazon.awssdk.services.qbusiness.model.MetadataEvent} that represents the
 * {@code ChatOutputStream$metadataEvent} event. Do not use this class directly. Instead, use the static builder methods
 * on {@link software.amazon.awssdk.services.qbusiness.model.ChatOutputStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultMetadataEvent extends MetadataEvent {
    private static final long serialVersionUID = 1L;

    DefaultMetadataEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        visitor.visitMetadataEvent(this);
    }

    @Override
    public ChatOutputStream.EventType sdkEventType() {
        return ChatOutputStream.EventType.METADATA_EVENT;
    }

    public interface Builder extends MetadataEvent.Builder {
        @Override
        DefaultMetadataEvent build();
    }

    private static final class BuilderImpl extends MetadataEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultMetadataEvent event) {
            super(event);
        }

        @Override
        public DefaultMetadataEvent build() {
            return new DefaultMetadataEvent(this);
        }
    }
}
