/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.BlockedPhrasesConfigurationUpdate;
import software.amazon.awssdk.services.qbusiness.model.CreatorModeConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.ResponseScope;
import software.amazon.awssdk.services.qbusiness.model.TopicConfiguration;
import software.amazon.awssdk.services.qbusiness.model.TopicConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChatControlsConfigurationRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateChatControlsConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::applicationId)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::clientToken)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RESPONSE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseScope").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::responseScopeAsString)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::responseScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseScope").build()}).build();
    private static final SdkField<BlockedPhrasesConfigurationUpdate> BLOCKED_PHRASES_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blockedPhrasesConfigurationUpdate").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::blockedPhrasesConfigurationUpdate)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::blockedPhrasesConfigurationUpdate)).constructor(BlockedPhrasesConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesConfigurationUpdate").build()}).build();
    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_TO_CREATE_OR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topicConfigurationsToCreateOrUpdate").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::topicConfigurationsToCreateOrUpdate)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::topicConfigurationsToCreateOrUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicConfigurationsToCreateOrUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topicConfigurationsToDelete").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::topicConfigurationsToDelete)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::topicConfigurationsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicConfigurationsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreatorModeConfiguration> CREATOR_MODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("creatorModeConfiguration").getter(UpdateChatControlsConfigurationRequest.getter(UpdateChatControlsConfigurationRequest::creatorModeConfiguration)).setter(UpdateChatControlsConfigurationRequest.setter(Builder::creatorModeConfiguration)).constructor(CreatorModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorModeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CLIENT_TOKEN_FIELD, RESPONSE_SCOPE_FIELD, BLOCKED_PHRASES_CONFIGURATION_UPDATE_FIELD, TOPIC_CONFIGURATIONS_TO_CREATE_OR_UPDATE_FIELD, TOPIC_CONFIGURATIONS_TO_DELETE_FIELD, CREATOR_MODE_CONFIGURATION_FIELD));
    private final String applicationId;
    private final String clientToken;
    private final String responseScope;
    private final BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate;
    private final List<TopicConfiguration> topicConfigurationsToCreateOrUpdate;
    private final List<TopicConfiguration> topicConfigurationsToDelete;
    private final CreatorModeConfiguration creatorModeConfiguration;

    private UpdateChatControlsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.responseScope = builder.responseScope;
        this.blockedPhrasesConfigurationUpdate = builder.blockedPhrasesConfigurationUpdate;
        this.topicConfigurationsToCreateOrUpdate = builder.topicConfigurationsToCreateOrUpdate;
        this.topicConfigurationsToDelete = builder.topicConfigurationsToDelete;
        this.creatorModeConfiguration = builder.creatorModeConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ResponseScope responseScope() {
        return ResponseScope.fromValue(this.responseScope);
    }

    public final String responseScopeAsString() {
        return this.responseScope;
    }

    public final BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate() {
        return this.blockedPhrasesConfigurationUpdate;
    }

    public final boolean hasTopicConfigurationsToCreateOrUpdate() {
        return this.topicConfigurationsToCreateOrUpdate != null && !(this.topicConfigurationsToCreateOrUpdate instanceof SdkAutoConstructList);
    }

    public final List<TopicConfiguration> topicConfigurationsToCreateOrUpdate() {
        return this.topicConfigurationsToCreateOrUpdate;
    }

    public final boolean hasTopicConfigurationsToDelete() {
        return this.topicConfigurationsToDelete != null && !(this.topicConfigurationsToDelete instanceof SdkAutoConstructList);
    }

    public final List<TopicConfiguration> topicConfigurationsToDelete() {
        return this.topicConfigurationsToDelete;
    }

    public final CreatorModeConfiguration creatorModeConfiguration() {
        return this.creatorModeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedPhrasesConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicConfigurationsToCreateOrUpdate() ? this.topicConfigurationsToCreateOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicConfigurationsToDelete() ? this.topicConfigurationsToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorModeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChatControlsConfigurationRequest)) {
            return false;
        }
        UpdateChatControlsConfigurationRequest other = (UpdateChatControlsConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.responseScopeAsString(), other.responseScopeAsString()) && Objects.equals(this.blockedPhrasesConfigurationUpdate(), other.blockedPhrasesConfigurationUpdate()) && this.hasTopicConfigurationsToCreateOrUpdate() == other.hasTopicConfigurationsToCreateOrUpdate() && Objects.equals(this.topicConfigurationsToCreateOrUpdate(), other.topicConfigurationsToCreateOrUpdate()) && this.hasTopicConfigurationsToDelete() == other.hasTopicConfigurationsToDelete() && Objects.equals(this.topicConfigurationsToDelete(), other.topicConfigurationsToDelete()) && Objects.equals(this.creatorModeConfiguration(), other.creatorModeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChatControlsConfigurationRequest").add("ApplicationId", (Object)this.applicationId()).add("ClientToken", (Object)this.clientToken()).add("ResponseScope", (Object)this.responseScopeAsString()).add("BlockedPhrasesConfigurationUpdate", (Object)this.blockedPhrasesConfigurationUpdate()).add("TopicConfigurationsToCreateOrUpdate", this.hasTopicConfigurationsToCreateOrUpdate() ? this.topicConfigurationsToCreateOrUpdate() : null).add("TopicConfigurationsToDelete", this.hasTopicConfigurationsToDelete() ? this.topicConfigurationsToDelete() : null).add("CreatorModeConfiguration", (Object)this.creatorModeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "responseScope": {
                return Optional.ofNullable(clazz.cast(this.responseScopeAsString()));
            }
            case "blockedPhrasesConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.blockedPhrasesConfigurationUpdate()));
            }
            case "topicConfigurationsToCreateOrUpdate": {
                return Optional.ofNullable(clazz.cast(this.topicConfigurationsToCreateOrUpdate()));
            }
            case "topicConfigurationsToDelete": {
                return Optional.ofNullable(clazz.cast(this.topicConfigurationsToDelete()));
            }
            case "creatorModeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.creatorModeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChatControlsConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateChatControlsConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String clientToken;
        private String responseScope;
        private BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate;
        private List<TopicConfiguration> topicConfigurationsToCreateOrUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<TopicConfiguration> topicConfigurationsToDelete = DefaultSdkAutoConstructList.getInstance();
        private CreatorModeConfiguration creatorModeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChatControlsConfigurationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.clientToken(model.clientToken);
            this.responseScope(model.responseScope);
            this.blockedPhrasesConfigurationUpdate(model.blockedPhrasesConfigurationUpdate);
            this.topicConfigurationsToCreateOrUpdate(model.topicConfigurationsToCreateOrUpdate);
            this.topicConfigurationsToDelete(model.topicConfigurationsToDelete);
            this.creatorModeConfiguration(model.creatorModeConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getResponseScope() {
            return this.responseScope;
        }

        public final void setResponseScope(String responseScope) {
            this.responseScope = responseScope;
        }

        @Override
        public final Builder responseScope(String responseScope) {
            this.responseScope = responseScope;
            return this;
        }

        @Override
        public final Builder responseScope(ResponseScope responseScope) {
            this.responseScope(responseScope == null ? null : responseScope.toString());
            return this;
        }

        public final BlockedPhrasesConfigurationUpdate.Builder getBlockedPhrasesConfigurationUpdate() {
            return this.blockedPhrasesConfigurationUpdate != null ? this.blockedPhrasesConfigurationUpdate.toBuilder() : null;
        }

        public final void setBlockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate.BuilderImpl blockedPhrasesConfigurationUpdate) {
            this.blockedPhrasesConfigurationUpdate = blockedPhrasesConfigurationUpdate != null ? blockedPhrasesConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate blockedPhrasesConfigurationUpdate) {
            this.blockedPhrasesConfigurationUpdate = blockedPhrasesConfigurationUpdate;
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurationsToCreateOrUpdate() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier.copyToBuilder(this.topicConfigurationsToCreateOrUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurationsToCreateOrUpdate(Collection<TopicConfiguration.BuilderImpl> topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate = TopicConfigurationsCopier.copyFromBuilder(topicConfigurationsToCreateOrUpdate);
        }

        @Override
        public final Builder topicConfigurationsToCreateOrUpdate(Collection<TopicConfiguration> topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate = TopicConfigurationsCopier.copy(topicConfigurationsToCreateOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToCreateOrUpdate(TopicConfiguration ... topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate(Arrays.asList(topicConfigurationsToCreateOrUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToCreateOrUpdate(Consumer<TopicConfiguration.Builder> ... topicConfigurationsToCreateOrUpdate) {
            this.topicConfigurationsToCreateOrUpdate(Stream.of(topicConfigurationsToCreateOrUpdate).map(c -> (TopicConfiguration)((TopicConfiguration.Builder)TopicConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurationsToDelete() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier.copyToBuilder(this.topicConfigurationsToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurationsToDelete(Collection<TopicConfiguration.BuilderImpl> topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete = TopicConfigurationsCopier.copyFromBuilder(topicConfigurationsToDelete);
        }

        @Override
        public final Builder topicConfigurationsToDelete(Collection<TopicConfiguration> topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete = TopicConfigurationsCopier.copy(topicConfigurationsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToDelete(TopicConfiguration ... topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete(Arrays.asList(topicConfigurationsToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurationsToDelete(Consumer<TopicConfiguration.Builder> ... topicConfigurationsToDelete) {
            this.topicConfigurationsToDelete(Stream.of(topicConfigurationsToDelete).map(c -> (TopicConfiguration)((TopicConfiguration.Builder)TopicConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreatorModeConfiguration.Builder getCreatorModeConfiguration() {
            return this.creatorModeConfiguration != null ? this.creatorModeConfiguration.toBuilder() : null;
        }

        public final void setCreatorModeConfiguration(CreatorModeConfiguration.BuilderImpl creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration != null ? creatorModeConfiguration.build() : null;
        }

        @Override
        public final Builder creatorModeConfiguration(CreatorModeConfiguration creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChatControlsConfigurationRequest build() {
            return new UpdateChatControlsConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChatControlsConfigurationRequest> {
        public Builder applicationId(String var1);

        public Builder clientToken(String var1);

        public Builder responseScope(String var1);

        public Builder responseScope(ResponseScope var1);

        public Builder blockedPhrasesConfigurationUpdate(BlockedPhrasesConfigurationUpdate var1);

        default public Builder blockedPhrasesConfigurationUpdate(Consumer<BlockedPhrasesConfigurationUpdate.Builder> blockedPhrasesConfigurationUpdate) {
            return this.blockedPhrasesConfigurationUpdate((BlockedPhrasesConfigurationUpdate)((BlockedPhrasesConfigurationUpdate.Builder)BlockedPhrasesConfigurationUpdate.builder().applyMutation(blockedPhrasesConfigurationUpdate)).build());
        }

        public Builder topicConfigurationsToCreateOrUpdate(Collection<TopicConfiguration> var1);

        public Builder topicConfigurationsToCreateOrUpdate(TopicConfiguration ... var1);

        public Builder topicConfigurationsToCreateOrUpdate(Consumer<TopicConfiguration.Builder> ... var1);

        public Builder topicConfigurationsToDelete(Collection<TopicConfiguration> var1);

        public Builder topicConfigurationsToDelete(TopicConfiguration ... var1);

        public Builder topicConfigurationsToDelete(Consumer<TopicConfiguration.Builder> ... var1);

        public Builder creatorModeConfiguration(CreatorModeConfiguration var1);

        default public Builder creatorModeConfiguration(Consumer<CreatorModeConfiguration.Builder> creatorModeConfiguration) {
            return this.creatorModeConfiguration((CreatorModeConfiguration)((CreatorModeConfiguration.Builder)CreatorModeConfiguration.builder().applyMutation(creatorModeConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

