/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.services.qbusiness.model.IdentityProviderConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceSamplePromptsControlMode;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWebExperienceResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetWebExperienceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::applicationId)).setter(GetWebExperienceResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webExperienceId").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::webExperienceId)).setter(GetWebExperienceResponse.setter(Builder::webExperienceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceId").build()}).build();
    private static final SdkField<String> WEB_EXPERIENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webExperienceArn").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::webExperienceArn)).setter(GetWebExperienceResponse.setter(Builder::webExperienceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceArn").build()}).build();
    private static final SdkField<String> DEFAULT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultEndpoint").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::defaultEndpoint)).setter(GetWebExperienceResponse.setter(Builder::defaultEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultEndpoint").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::statusAsString)).setter(GetWebExperienceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::createdAt)).setter(GetWebExperienceResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::updatedAt)).setter(GetWebExperienceResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::title)).setter(GetWebExperienceResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtitle").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::subtitle)).setter(GetWebExperienceResponse.setter(Builder::subtitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()}).build();
    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("welcomeMessage").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::welcomeMessage)).setter(GetWebExperienceResponse.setter(Builder::welcomeMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()}).build();
    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samplePromptsControlMode").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::samplePromptsControlModeAsString)).setter(GetWebExperienceResponse.setter(Builder::samplePromptsControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::roleArn)).setter(GetWebExperienceResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identityProviderConfiguration").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::identityProviderConfiguration)).setter(GetWebExperienceResponse.setter(Builder::identityProviderConfiguration)).constructor(IdentityProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfiguration").build()}).build();
    private static final SdkField<WebExperienceAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::authenticationConfiguration)).setter(GetWebExperienceResponse.setter(Builder::authenticationConfiguration)).constructor(WebExperienceAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetWebExperienceResponse.getter(GetWebExperienceResponse::error)).setter(GetWebExperienceResponse.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, WEB_EXPERIENCE_ID_FIELD, WEB_EXPERIENCE_ARN_FIELD, DEFAULT_ENDPOINT_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TITLE_FIELD, SUBTITLE_FIELD, WELCOME_MESSAGE_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, ROLE_ARN_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, ERROR_FIELD));
    private final String applicationId;
    private final String webExperienceId;
    private final String webExperienceArn;
    private final String defaultEndpoint;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String title;
    private final String subtitle;
    private final String welcomeMessage;
    private final String samplePromptsControlMode;
    private final String roleArn;
    private final IdentityProviderConfiguration identityProviderConfiguration;
    private final WebExperienceAuthConfiguration authenticationConfiguration;
    private final ErrorDetail error;

    private GetWebExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.webExperienceId = builder.webExperienceId;
        this.webExperienceArn = builder.webExperienceArn;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.welcomeMessage = builder.welcomeMessage;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.roleArn = builder.roleArn;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.error = builder.error;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String webExperienceId() {
        return this.webExperienceId;
    }

    public final String webExperienceArn() {
        return this.webExperienceArn;
    }

    public final String defaultEndpoint() {
        return this.defaultEndpoint;
    }

    public final WebExperienceStatus status() {
        return WebExperienceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String title() {
        return this.title;
    }

    public final String subtitle() {
        return this.subtitle;
    }

    public final String welcomeMessage() {
        return this.welcomeMessage;
    }

    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(this.samplePromptsControlMode);
    }

    public final String samplePromptsControlModeAsString() {
        return this.samplePromptsControlMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return this.identityProviderConfiguration;
    }

    @Deprecated
    public final WebExperienceAuthConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webExperienceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.welcomeMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebExperienceResponse)) {
            return false;
        }
        GetWebExperienceResponse other = (GetWebExperienceResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.webExperienceId(), other.webExperienceId()) && Objects.equals(this.webExperienceArn(), other.webExperienceArn()) && Objects.equals(this.defaultEndpoint(), other.defaultEndpoint()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.welcomeMessage(), other.welcomeMessage()) && Objects.equals(this.samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.identityProviderConfiguration(), other.identityProviderConfiguration()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"GetWebExperienceResponse").add("ApplicationId", (Object)this.applicationId()).add("WebExperienceId", (Object)this.webExperienceId()).add("WebExperienceArn", (Object)this.webExperienceArn()).add("DefaultEndpoint", (Object)this.defaultEndpoint()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("WelcomeMessage", (Object)this.welcomeMessage()).add("SamplePromptsControlMode", (Object)this.samplePromptsControlModeAsString()).add("RoleArn", (Object)this.roleArn()).add("IdentityProviderConfiguration", (Object)this.identityProviderConfiguration()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "webExperienceId": {
                return Optional.ofNullable(clazz.cast(this.webExperienceId()));
            }
            case "webExperienceArn": {
                return Optional.ofNullable(clazz.cast(this.webExperienceArn()));
            }
            case "defaultEndpoint": {
                return Optional.ofNullable(clazz.cast(this.defaultEndpoint()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "welcomeMessage": {
                return Optional.ofNullable(clazz.cast(this.welcomeMessage()));
            }
            case "samplePromptsControlMode": {
                return Optional.ofNullable(clazz.cast(this.samplePromptsControlModeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "identityProviderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfiguration()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebExperienceResponse, T> g) {
        return obj -> g.apply((GetWebExperienceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String webExperienceId;
        private String webExperienceArn;
        private String defaultEndpoint;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;
        private String title;
        private String subtitle;
        private String welcomeMessage;
        private String samplePromptsControlMode;
        private String roleArn;
        private IdentityProviderConfiguration identityProviderConfiguration;
        private WebExperienceAuthConfiguration authenticationConfiguration;
        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebExperienceResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.webExperienceId(model.webExperienceId);
            this.webExperienceArn(model.webExperienceArn);
            this.defaultEndpoint(model.defaultEndpoint);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.welcomeMessage(model.welcomeMessage);
            this.samplePromptsControlMode(model.samplePromptsControlMode);
            this.roleArn(model.roleArn);
            this.identityProviderConfiguration(model.identityProviderConfiguration);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.error(model.error);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getWebExperienceId() {
            return this.webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final String getWebExperienceArn() {
            return this.webExperienceArn;
        }

        public final void setWebExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
        }

        @Override
        public final Builder webExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
            return this;
        }

        public final String getDefaultEndpoint() {
            return this.defaultEndpoint;
        }

        public final void setDefaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public final Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WebExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSubtitle() {
            return this.subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return this.samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration != null ? this.identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build() : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        @Deprecated
        public final WebExperienceAuthConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setAuthenticationConfiguration(WebExperienceAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public GetWebExperienceResponse build() {
            return new GetWebExperienceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWebExperienceResponse> {
        public Builder applicationId(String var1);

        public Builder webExperienceId(String var1);

        public Builder webExperienceArn(String var1);

        public Builder defaultEndpoint(String var1);

        public Builder status(String var1);

        public Builder status(WebExperienceStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder title(String var1);

        public Builder subtitle(String var1);

        public Builder welcomeMessage(String var1);

        public Builder samplePromptsControlMode(String var1);

        public Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode var1);

        public Builder roleArn(String var1);

        public Builder identityProviderConfiguration(IdentityProviderConfiguration var1);

        default public Builder identityProviderConfiguration(Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return this.identityProviderConfiguration((IdentityProviderConfiguration)((IdentityProviderConfiguration.Builder)IdentityProviderConfiguration.builder().applyMutation(identityProviderConfiguration)).build());
        }

        @Deprecated
        public Builder authenticationConfiguration(WebExperienceAuthConfiguration var1);

        @Deprecated
        default public Builder authenticationConfiguration(Consumer<WebExperienceAuthConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((WebExperienceAuthConfiguration)((WebExperienceAuthConfiguration.Builder)WebExperienceAuthConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }
    }
}

