/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q Business to
 * perform the requested plugin action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionReviewPayloadFieldAllowedValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionReviewPayloadFieldAllowedValue.Builder, ActionReviewPayloadFieldAllowedValue> {
    private static final SdkField<Document> VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("value").getter(getter(ActionReviewPayloadFieldAllowedValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<Document> DISPLAY_VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("displayValue").getter(getter(ActionReviewPayloadFieldAllowedValue::displayValue))
            .setter(setter(Builder::displayValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            DISPLAY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document value;

    private final Document displayValue;

    private ActionReviewPayloadFieldAllowedValue(BuilderImpl builder) {
        this.value = builder.value;
        this.displayValue = builder.displayValue;
    }

    /**
     * <p>
     * The field value.
     * </p>
     * 
     * @return The field value.
     */
    public final Document value() {
        return value;
    }

    /**
     * <p>
     * The name of the field.
     * </p>
     * 
     * @return The name of the field.
     */
    public final Document displayValue() {
        return displayValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(displayValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReviewPayloadFieldAllowedValue)) {
            return false;
        }
        ActionReviewPayloadFieldAllowedValue other = (ActionReviewPayloadFieldAllowedValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(displayValue(), other.displayValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionReviewPayloadFieldAllowedValue").add("Value", value()).add("DisplayValue", displayValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "displayValue":
            return Optional.ofNullable(clazz.cast(displayValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionReviewPayloadFieldAllowedValue, T> g) {
        return obj -> g.apply((ActionReviewPayloadFieldAllowedValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionReviewPayloadFieldAllowedValue> {
        /**
         * <p>
         * The field value.
         * </p>
         * 
         * @param value
         *        The field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Document value);

        /**
         * <p>
         * The name of the field.
         * </p>
         * 
         * @param displayValue
         *        The name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayValue(Document displayValue);
    }

    static final class BuilderImpl implements Builder {
        private Document value;

        private Document displayValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionReviewPayloadFieldAllowedValue model) {
            value(model.value);
            displayValue(model.displayValue);
        }

        public final Document getValue() {
            return value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final Document getDisplayValue() {
            return displayValue;
        }

        public final void setDisplayValue(Document displayValue) {
            this.displayValue = displayValue;
        }

        @Override
        public final Builder displayValue(Document displayValue) {
            this.displayValue = displayValue;
            return this;
        }

        @Override
        public ActionReviewPayloadFieldAllowedValue build() {
            return new ActionReviewPayloadFieldAllowedValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
