/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for an Amazon Q Business application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Application::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(Application::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Application::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Application::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Application::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityType").getter(getter(Application::identityTypeAsString)).setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            APPLICATION_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, IDENTITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final String applicationId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final String identityType;

    private Application(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.applicationId = builder.applicationId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.identityType = builder.identityType;
    }

    /**
     * <p>
     * The name of the Amazon Q Business application.
     * </p>
     * 
     * @return The name of the Amazon Q Business application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier for the Amazon Q Business application.
     * </p>
     * 
     * @return The identifier for the Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was created.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The status of the Amazon Q Business application. The application is ready to use when the status is
     * <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business application. The application is ready to use when the status is
     *         <code>ACTIVE</code>.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Q Business application. The application is ready to use when the status is
     * <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business application. The application is ready to use when the status is
     *         <code>ACTIVE</code>.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Application").add("DisplayName", displayName()).add("ApplicationId", applicationId())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Status", statusAsString())
                .add("IdentityType", identityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "identityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The name of the Amazon Q Business application.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier for the Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The identifier for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The status of the Amazon Q Business application. The application is ready to use when the status is
         * <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business application. The application is ready to use when the status is
         *        <code>ACTIVE</code>.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Q Business application. The application is ready to use when the status is
         * <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business application. The application is ready to use when the status is
         *        <code>ACTIVE</code>.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private String applicationId;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private String identityType;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            displayName(model.displayName);
            applicationId(model.applicationId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            identityType(model.identityType);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
