/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on boosting <code>DATE</code> type document attributes.
 * </p>
 * <p>
 * For more information on how boosting document attributes work in Amazon Q Business, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html">Boosting using document
 * attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateAttributeBoostingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DateAttributeBoostingConfiguration.Builder, DateAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("boostingLevel").getter(getter(DateAttributeBoostingConfiguration::boostingLevelAsString))
            .setter(setter(Builder::boostingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()).build();

    private static final SdkField<Long> BOOSTING_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("boostingDurationInSeconds")
            .getter(getter(DateAttributeBoostingConfiguration::boostingDurationInSeconds))
            .setter(setter(Builder::boostingDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingDurationInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD,
            BOOSTING_DURATION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String boostingLevel;

    private final Long boostingDurationInSeconds;

    private DateAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
        this.boostingDurationInSeconds = builder.boostingDurationInSeconds;
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see DocumentAttributeBoostingLevel
     */
    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(boostingLevel);
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see DocumentAttributeBoostingLevel
     */
    public final String boostingLevelAsString() {
        return boostingLevel;
    }

    /**
     * <p>
     * Specifies the duration, in seconds, of a boost applies to a <code>DATE</code> type document attribute.
     * </p>
     * 
     * @return Specifies the duration, in seconds, of a boost applies to a <code>DATE</code> type document attribute.
     */
    public final Long boostingDurationInSeconds() {
        return boostingDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boostingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(boostingDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateAttributeBoostingConfiguration)) {
            return false;
        }
        DateAttributeBoostingConfiguration other = (DateAttributeBoostingConfiguration) obj;
        return Objects.equals(boostingLevelAsString(), other.boostingLevelAsString())
                && Objects.equals(boostingDurationInSeconds(), other.boostingDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateAttributeBoostingConfiguration").add("BoostingLevel", boostingLevelAsString())
                .add("BoostingDurationInSeconds", boostingDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boostingLevel":
            return Optional.ofNullable(clazz.cast(boostingLevelAsString()));
        case "boostingDurationInSeconds":
            return Optional.ofNullable(clazz.cast(boostingDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((DateAttributeBoostingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateAttributeBoostingConfiguration> {
        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies how much a document attribute is boosted.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(String boostingLevel);

        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies how much a document attribute is boosted.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel);

        /**
         * <p>
         * Specifies the duration, in seconds, of a boost applies to a <code>DATE</code> type document attribute.
         * </p>
         * 
         * @param boostingDurationInSeconds
         *        Specifies the duration, in seconds, of a boost applies to a <code>DATE</code> type document attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boostingDurationInSeconds(Long boostingDurationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String boostingLevel;

        private Long boostingDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DateAttributeBoostingConfiguration model) {
            boostingLevel(model.boostingLevel);
            boostingDurationInSeconds(model.boostingDurationInSeconds);
        }

        public final String getBoostingLevel() {
            return boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public final Long getBoostingDurationInSeconds() {
            return boostingDurationInSeconds;
        }

        public final void setBoostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
        }

        @Override
        public final Builder boostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
            return this;
        }

        @Override
        public DateAttributeBoostingConfiguration build() {
            return new DateAttributeBoostingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
