/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the OIDC-compliant identity provider (IdP) used to authenticate end users of an Amazon Q Business
 * web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenIDConnectProviderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenIDConnectProviderConfiguration.Builder, OpenIDConnectProviderConfiguration> {
    private static final SdkField<String> SECRETS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretsArn").getter(getter(OpenIDConnectProviderConfiguration::secretsArn))
            .setter(setter(Builder::secretsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsArn").build()).build();

    private static final SdkField<String> SECRETS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretsRole").getter(getter(OpenIDConnectProviderConfiguration::secretsRole))
            .setter(setter(Builder::secretsRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRETS_ARN_FIELD,
            SECRETS_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String secretsArn;

    private final String secretsRole;

    private OpenIDConnectProviderConfiguration(BuilderImpl builder) {
        this.secretsArn = builder.secretsArn;
        this.secretsRole = builder.secretsRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
     */
    public final String secretsArn() {
        return secretsArn;
    }

    /**
     * <p>
     * An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC client
     * secret.
     * </p>
     * 
     * @return An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC
     *         client secret.
     */
    public final String secretsRole() {
        return secretsRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretsArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIDConnectProviderConfiguration)) {
            return false;
        }
        OpenIDConnectProviderConfiguration other = (OpenIDConnectProviderConfiguration) obj;
        return Objects.equals(secretsArn(), other.secretsArn()) && Objects.equals(secretsRole(), other.secretsRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenIDConnectProviderConfiguration").add("SecretsArn", secretsArn())
                .add("SecretsRole", secretsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretsArn":
            return Optional.ofNullable(clazz.cast(secretsArn()));
        case "secretsRole":
            return Optional.ofNullable(clazz.cast(secretsRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenIDConnectProviderConfiguration, T> g) {
        return obj -> g.apply((OpenIDConnectProviderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenIDConnectProviderConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
         * </p>
         * 
         * @param secretsArn
         *        The Amazon Resource Name (ARN) of a Secrets Manager secret containing the OIDC client secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsArn(String secretsArn);

        /**
         * <p>
         * An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC client
         * secret.
         * </p>
         * 
         * @param secretsRole
         *        An IAM role with permissions to access KMS to decrypt the Secrets Manager secret containing your OIDC
         *        client secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsRole(String secretsRole);
    }

    static final class BuilderImpl implements Builder {
        private String secretsArn;

        private String secretsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIDConnectProviderConfiguration model) {
            secretsArn(model.secretsArn);
            secretsRole(model.secretsRole);
        }

        public final String getSecretsArn() {
            return secretsArn;
        }

        public final void setSecretsArn(String secretsArn) {
            this.secretsArn = secretsArn;
        }

        @Override
        public final Builder secretsArn(String secretsArn) {
            this.secretsArn = secretsArn;
            return this;
        }

        public final String getSecretsRole() {
            return secretsRole;
        }

        public final void setSecretsRole(String secretsRole) {
            this.secretsRole = secretsRole;
        }

        @Override
        public final Builder secretsRole(String secretsRole) {
            this.secretsRole = secretsRole;
            return this;
        }

        @Override
        public OpenIDConnectProviderConfiguration build() {
            return new OpenIDConnectProviderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
