/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackRequest extends QBusinessRequest implements
        ToCopyableBuilder<PutFeedbackRequest.Builder, PutFeedbackRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(PutFeedbackRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(PutFeedbackRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(PutFeedbackRequest::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("conversationId").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(PutFeedbackRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()).build();

    private static final SdkField<Instant> MESSAGE_COPIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("messageCopiedAt").getter(getter(PutFeedbackRequest::messageCopiedAt))
            .setter(setter(Builder::messageCopiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageCopiedAt").build()).build();

    private static final SdkField<MessageUsefulnessFeedback> MESSAGE_USEFULNESS_FIELD = SdkField
            .<MessageUsefulnessFeedback> builder(MarshallingType.SDK_POJO).memberName("messageUsefulness")
            .getter(getter(PutFeedbackRequest::messageUsefulness)).setter(setter(Builder::messageUsefulness))
            .constructor(MessageUsefulnessFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageUsefulness").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            USER_ID_FIELD, CONVERSATION_ID_FIELD, MESSAGE_ID_FIELD, MESSAGE_COPIED_AT_FIELD, MESSAGE_USEFULNESS_FIELD));

    private final String applicationId;

    private final String userId;

    private final String conversationId;

    private final String messageId;

    private final Instant messageCopiedAt;

    private final MessageUsefulnessFeedback messageUsefulness;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.conversationId = builder.conversationId;
        this.messageId = builder.messageId;
        this.messageCopiedAt = builder.messageCopiedAt;
        this.messageUsefulness = builder.messageUsefulness;
    }

    /**
     * <p>
     * The identifier of the application associated with the feedback.
     * </p>
     * 
     * @return The identifier of the application associated with the feedback.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the user giving the feedback.
     * </p>
     * 
     * @return The identifier of the user giving the feedback.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The identifier of the conversation the feedback is attached to.
     * </p>
     * 
     * @return The identifier of the conversation the feedback is attached to.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of the chat message that the feedback was given for.
     * </p>
     * 
     * @return The identifier of the chat message that the feedback was given for.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The timestamp for when the feedback was recorded.
     * </p>
     * 
     * @return The timestamp for when the feedback was recorded.
     */
    public final Instant messageCopiedAt() {
        return messageCopiedAt;
    }

    /**
     * <p>
     * The feedback usefulness value given by the user to the chat message.
     * </p>
     * 
     * @return The feedback usefulness value given by the user to the chat message.
     */
    public final MessageUsefulnessFeedback messageUsefulness() {
        return messageUsefulness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(messageCopiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(messageUsefulness());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(conversationId(), other.conversationId()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(messageCopiedAt(), other.messageCopiedAt())
                && Objects.equals(messageUsefulness(), other.messageUsefulness());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackRequest").add("ApplicationId", applicationId()).add("UserId", userId())
                .add("ConversationId", conversationId()).add("MessageId", messageId()).add("MessageCopiedAt", messageCopiedAt())
                .add("MessageUsefulness", messageUsefulness()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "messageCopiedAt":
            return Optional.ofNullable(clazz.cast(messageCopiedAt()));
        case "messageUsefulness":
            return Optional.ofNullable(clazz.cast(messageUsefulness()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackRequest> {
        /**
         * <p>
         * The identifier of the application associated with the feedback.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application associated with the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the user giving the feedback.
         * </p>
         * 
         * @param userId
         *        The identifier of the user giving the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The identifier of the conversation the feedback is attached to.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the conversation the feedback is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of the chat message that the feedback was given for.
         * </p>
         * 
         * @param messageId
         *        The identifier of the chat message that the feedback was given for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The timestamp for when the feedback was recorded.
         * </p>
         * 
         * @param messageCopiedAt
         *        The timestamp for when the feedback was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageCopiedAt(Instant messageCopiedAt);

        /**
         * <p>
         * The feedback usefulness value given by the user to the chat message.
         * </p>
         * 
         * @param messageUsefulness
         *        The feedback usefulness value given by the user to the chat message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageUsefulness(MessageUsefulnessFeedback messageUsefulness);

        /**
         * <p>
         * The feedback usefulness value given by the user to the chat message.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageUsefulnessFeedback.Builder}
         * avoiding the need to create one manually via {@link MessageUsefulnessFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageUsefulnessFeedback.Builder#build()} is called immediately
         * and its result is passed to {@link #messageUsefulness(MessageUsefulnessFeedback)}.
         * 
         * @param messageUsefulness
         *        a consumer that will call methods on {@link MessageUsefulnessFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageUsefulness(MessageUsefulnessFeedback)
         */
        default Builder messageUsefulness(Consumer<MessageUsefulnessFeedback.Builder> messageUsefulness) {
            return messageUsefulness(MessageUsefulnessFeedback.builder().applyMutation(messageUsefulness).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String userId;

        private String conversationId;

        private String messageId;

        private Instant messageCopiedAt;

        private MessageUsefulnessFeedback messageUsefulness;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            applicationId(model.applicationId);
            userId(model.userId);
            conversationId(model.conversationId);
            messageId(model.messageId);
            messageCopiedAt(model.messageCopiedAt);
            messageUsefulness(model.messageUsefulness);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Instant getMessageCopiedAt() {
            return messageCopiedAt;
        }

        public final void setMessageCopiedAt(Instant messageCopiedAt) {
            this.messageCopiedAt = messageCopiedAt;
        }

        @Override
        public final Builder messageCopiedAt(Instant messageCopiedAt) {
            this.messageCopiedAt = messageCopiedAt;
            return this;
        }

        public final MessageUsefulnessFeedback.Builder getMessageUsefulness() {
            return messageUsefulness != null ? messageUsefulness.toBuilder() : null;
        }

        public final void setMessageUsefulness(MessageUsefulnessFeedback.BuilderImpl messageUsefulness) {
            this.messageUsefulness = messageUsefulness != null ? messageUsefulness.build() : null;
        }

        @Override
        public final Builder messageUsefulness(MessageUsefulnessFeedback messageUsefulness) {
            this.messageUsefulness = messageUsefulness;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
