/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the SAML 2.0-compliant identity provider (IdP) used to authenticate end users of an Amazon Q
 * Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlProviderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SamlProviderConfiguration.Builder, SamlProviderConfiguration> {
    private static final SdkField<String> AUTHENTICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationUrl").getter(getter(SamlProviderConfiguration::authenticationUrl))
            .setter(setter(Builder::authenticationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationUrl;

    private SamlProviderConfiguration(BuilderImpl builder) {
        this.authenticationUrl = builder.authenticationUrl;
    }

    /**
     * <p>
     * The URL where Amazon Q Business end users will be redirected for authentication.
     * </p>
     * 
     * @return The URL where Amazon Q Business end users will be redirected for authentication.
     */
    public final String authenticationUrl() {
        return authenticationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlProviderConfiguration)) {
            return false;
        }
        SamlProviderConfiguration other = (SamlProviderConfiguration) obj;
        return Objects.equals(authenticationUrl(), other.authenticationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlProviderConfiguration").add("AuthenticationUrl", authenticationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationUrl":
            return Optional.ofNullable(clazz.cast(authenticationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamlProviderConfiguration, T> g) {
        return obj -> g.apply((SamlProviderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlProviderConfiguration> {
        /**
         * <p>
         * The URL where Amazon Q Business end users will be redirected for authentication.
         * </p>
         * 
         * @param authenticationUrl
         *        The URL where Amazon Q Business end users will be redirected for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationUrl(String authenticationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlProviderConfiguration model) {
            authenticationUrl(model.authenticationUrl);
        }

        public final String getAuthenticationUrl() {
            return authenticationUrl;
        }

        public final void setAuthenticationUrl(String authenticationUrl) {
            this.authenticationUrl = authenticationUrl;
        }

        @Override
        public final Builder authenticationUrl(String authenticationUrl) {
            this.authenticationUrl = authenticationUrl;
            return this;
        }

        @Override
        public SamlProviderConfiguration build() {
            return new SamlProviderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
