/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserResponse extends QBusinessResponse implements
        ToCopyableBuilder<UpdateUserResponse.Builder, UpdateUserResponse> {
    private static final SdkField<List<UserAlias>> USER_ALIASES_ADDED_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliasesAdded")
            .getter(getter(UpdateUserResponse::userAliasesAdded))
            .setter(setter(Builder::userAliasesAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesAdded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserAlias>> USER_ALIASES_UPDATED_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliasesUpdated")
            .getter(getter(UpdateUserResponse::userAliasesUpdated))
            .setter(setter(Builder::userAliasesUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesUpdated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserAlias>> USER_ALIASES_DELETED_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliasesDeleted")
            .getter(getter(UpdateUserResponse::userAliasesDeleted))
            .setter(setter(Builder::userAliasesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ALIASES_ADDED_FIELD,
            USER_ALIASES_UPDATED_FIELD, USER_ALIASES_DELETED_FIELD));

    private final List<UserAlias> userAliasesAdded;

    private final List<UserAlias> userAliasesUpdated;

    private final List<UserAlias> userAliasesDeleted;

    private UpdateUserResponse(BuilderImpl builder) {
        super(builder);
        this.userAliasesAdded = builder.userAliasesAdded;
        this.userAliasesUpdated = builder.userAliasesUpdated;
        this.userAliasesDeleted = builder.userAliasesDeleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliasesAdded property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliasesAdded() {
        return userAliasesAdded != null && !(userAliasesAdded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user aliases that have been to be added to a user id.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliasesAdded} method.
     * </p>
     * 
     * @return The user aliases that have been to be added to a user id.
     */
    public final List<UserAlias> userAliasesAdded() {
        return userAliasesAdded;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliasesUpdated property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliasesUpdated() {
        return userAliasesUpdated != null && !(userAliasesUpdated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user aliases attached to a user id that have been updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliasesUpdated} method.
     * </p>
     * 
     * @return The user aliases attached to a user id that have been updated.
     */
    public final List<UserAlias> userAliasesUpdated() {
        return userAliasesUpdated;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliasesDeleted property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliasesDeleted() {
        return userAliasesDeleted != null && !(userAliasesDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user aliases that have been deleted from a user id.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliasesDeleted} method.
     * </p>
     * 
     * @return The user aliases that have been deleted from a user id.
     */
    public final List<UserAlias> userAliasesDeleted() {
        return userAliasesDeleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliasesAdded() ? userAliasesAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliasesUpdated() ? userAliasesUpdated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliasesDeleted() ? userAliasesDeleted() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserResponse)) {
            return false;
        }
        UpdateUserResponse other = (UpdateUserResponse) obj;
        return hasUserAliasesAdded() == other.hasUserAliasesAdded()
                && Objects.equals(userAliasesAdded(), other.userAliasesAdded())
                && hasUserAliasesUpdated() == other.hasUserAliasesUpdated()
                && Objects.equals(userAliasesUpdated(), other.userAliasesUpdated())
                && hasUserAliasesDeleted() == other.hasUserAliasesDeleted()
                && Objects.equals(userAliasesDeleted(), other.userAliasesDeleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserResponse").add("UserAliasesAdded", hasUserAliasesAdded() ? userAliasesAdded() : null)
                .add("UserAliasesUpdated", hasUserAliasesUpdated() ? userAliasesUpdated() : null)
                .add("UserAliasesDeleted", hasUserAliasesDeleted() ? userAliasesDeleted() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAliasesAdded":
            return Optional.ofNullable(clazz.cast(userAliasesAdded()));
        case "userAliasesUpdated":
            return Optional.ofNullable(clazz.cast(userAliasesUpdated()));
        case "userAliasesDeleted":
            return Optional.ofNullable(clazz.cast(userAliasesDeleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserResponse, T> g) {
        return obj -> g.apply((UpdateUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserResponse> {
        /**
         * <p>
         * The user aliases that have been to be added to a user id.
         * </p>
         * 
         * @param userAliasesAdded
         *        The user aliases that have been to be added to a user id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesAdded(Collection<UserAlias> userAliasesAdded);

        /**
         * <p>
         * The user aliases that have been to be added to a user id.
         * </p>
         * 
         * @param userAliasesAdded
         *        The user aliases that have been to be added to a user id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesAdded(UserAlias... userAliasesAdded);

        /**
         * <p>
         * The user aliases that have been to be added to a user id.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliasesAdded(List<UserAlias>)}.
         * 
         * @param userAliasesAdded
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliasesAdded(java.util.Collection<UserAlias>)
         */
        Builder userAliasesAdded(Consumer<UserAlias.Builder>... userAliasesAdded);

        /**
         * <p>
         * The user aliases attached to a user id that have been updated.
         * </p>
         * 
         * @param userAliasesUpdated
         *        The user aliases attached to a user id that have been updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesUpdated(Collection<UserAlias> userAliasesUpdated);

        /**
         * <p>
         * The user aliases attached to a user id that have been updated.
         * </p>
         * 
         * @param userAliasesUpdated
         *        The user aliases attached to a user id that have been updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesUpdated(UserAlias... userAliasesUpdated);

        /**
         * <p>
         * The user aliases attached to a user id that have been updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliasesUpdated(List<UserAlias>)}.
         * 
         * @param userAliasesUpdated
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliasesUpdated(java.util.Collection<UserAlias>)
         */
        Builder userAliasesUpdated(Consumer<UserAlias.Builder>... userAliasesUpdated);

        /**
         * <p>
         * The user aliases that have been deleted from a user id.
         * </p>
         * 
         * @param userAliasesDeleted
         *        The user aliases that have been deleted from a user id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesDeleted(Collection<UserAlias> userAliasesDeleted);

        /**
         * <p>
         * The user aliases that have been deleted from a user id.
         * </p>
         * 
         * @param userAliasesDeleted
         *        The user aliases that have been deleted from a user id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesDeleted(UserAlias... userAliasesDeleted);

        /**
         * <p>
         * The user aliases that have been deleted from a user id.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliasesDeleted(List<UserAlias>)}.
         * 
         * @param userAliasesDeleted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliasesDeleted(java.util.Collection<UserAlias>)
         */
        Builder userAliasesDeleted(Consumer<UserAlias.Builder>... userAliasesDeleted);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<UserAlias> userAliasesAdded = DefaultSdkAutoConstructList.getInstance();

        private List<UserAlias> userAliasesUpdated = DefaultSdkAutoConstructList.getInstance();

        private List<UserAlias> userAliasesDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserResponse model) {
            super(model);
            userAliasesAdded(model.userAliasesAdded);
            userAliasesUpdated(model.userAliasesUpdated);
            userAliasesDeleted(model.userAliasesDeleted);
        }

        public final List<UserAlias.Builder> getUserAliasesAdded() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesAdded);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesAdded(Collection<UserAlias.BuilderImpl> userAliasesAdded) {
            this.userAliasesAdded = UserAliasesCopier.copyFromBuilder(userAliasesAdded);
        }

        @Override
        public final Builder userAliasesAdded(Collection<UserAlias> userAliasesAdded) {
            this.userAliasesAdded = UserAliasesCopier.copy(userAliasesAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesAdded(UserAlias... userAliasesAdded) {
            userAliasesAdded(Arrays.asList(userAliasesAdded));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesAdded(Consumer<UserAlias.Builder>... userAliasesAdded) {
            userAliasesAdded(Stream.of(userAliasesAdded).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesUpdated() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesUpdated);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesUpdated(Collection<UserAlias.BuilderImpl> userAliasesUpdated) {
            this.userAliasesUpdated = UserAliasesCopier.copyFromBuilder(userAliasesUpdated);
        }

        @Override
        public final Builder userAliasesUpdated(Collection<UserAlias> userAliasesUpdated) {
            this.userAliasesUpdated = UserAliasesCopier.copy(userAliasesUpdated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesUpdated(UserAlias... userAliasesUpdated) {
            userAliasesUpdated(Arrays.asList(userAliasesUpdated));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesUpdated(Consumer<UserAlias.Builder>... userAliasesUpdated) {
            userAliasesUpdated(Stream.of(userAliasesUpdated).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesDeleted() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesDeleted(Collection<UserAlias.BuilderImpl> userAliasesDeleted) {
            this.userAliasesDeleted = UserAliasesCopier.copyFromBuilder(userAliasesDeleted);
        }

        @Override
        public final Builder userAliasesDeleted(Collection<UserAlias> userAliasesDeleted) {
            this.userAliasesDeleted = UserAliasesCopier.copy(userAliasesDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesDeleted(UserAlias... userAliasesDeleted) {
            userAliasesDeleted(Arrays.asList(userAliasesDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesDeleted(Consumer<UserAlias.Builder>... userAliasesDeleted) {
            userAliasesDeleted(Stream.of(userAliasesDeleted).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateUserResponse build() {
            return new UpdateUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
