/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the authorization configuration information needed to deploy a Amazon Q Business web experience to end
 * users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebExperienceAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WebExperienceAuthConfiguration.Builder, WebExperienceAuthConfiguration> {
    private static final SdkField<SamlConfiguration> SAML_CONFIGURATION_FIELD = SdkField
            .<SamlConfiguration> builder(MarshallingType.SDK_POJO).memberName("samlConfiguration")
            .getter(getter(WebExperienceAuthConfiguration::samlConfiguration)).setter(setter(Builder::samlConfiguration))
            .constructor(SamlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SamlConfiguration samlConfiguration;

    private final Type type;

    private WebExperienceAuthConfiguration(BuilderImpl builder) {
        this.samlConfiguration = builder.samlConfiguration;
        this.type = builder.type;
    }

    /**
     * Returns the value of the SamlConfiguration property for this object.
     * 
     * @return The value of the SamlConfiguration property for this object.
     */
    public final SamlConfiguration samlConfiguration() {
        return samlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebExperienceAuthConfiguration)) {
            return false;
        }
        WebExperienceAuthConfiguration other = (WebExperienceAuthConfiguration) obj;
        return Objects.equals(samlConfiguration(), other.samlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebExperienceAuthConfiguration").add("SamlConfiguration", samlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "samlConfiguration":
            return Optional.ofNullable(clazz.cast(samlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #samlConfiguration()} initialized to the given value.
     *
     * Sets the value of the SamlConfiguration property for this object.
     *
     * @param samlConfiguration
     *        The new value for the SamlConfiguration property for this object.
     */
    public static WebExperienceAuthConfiguration fromSamlConfiguration(SamlConfiguration samlConfiguration) {
        return builder().samlConfiguration(samlConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #samlConfiguration()} initialized to the given value.
     *
     * Sets the value of the SamlConfiguration property for this object.
     *
     * @param samlConfiguration
     *        The new value for the SamlConfiguration property for this object.
     */
    public static WebExperienceAuthConfiguration fromSamlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
        SamlConfiguration.Builder builder = SamlConfiguration.builder();
        samlConfiguration.accept(builder);
        return fromSamlConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebExperienceAuthConfiguration, T> g) {
        return obj -> g.apply((WebExperienceAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebExperienceAuthConfiguration> {
        /**
         * Sets the value of the SamlConfiguration property for this object.
         *
         * @param samlConfiguration
         *        The new value for the SamlConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlConfiguration(SamlConfiguration samlConfiguration);

        /**
         * Sets the value of the SamlConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SamlConfiguration.Builder} avoiding the
         * need to create one manually via {@link SamlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #samlConfiguration(SamlConfiguration)}.
         * 
         * @param samlConfiguration
         *        a consumer that will call methods on {@link SamlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlConfiguration(SamlConfiguration)
         */
        default Builder samlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
            return samlConfiguration(SamlConfiguration.builder().applyMutation(samlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SamlConfiguration samlConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WebExperienceAuthConfiguration model) {
            samlConfiguration(model.samlConfiguration);
        }

        public final SamlConfiguration.Builder getSamlConfiguration() {
            return samlConfiguration != null ? samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlConfiguration.BuilderImpl samlConfiguration) {
            Object oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
            handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
        }

        @Override
        public final Builder samlConfiguration(SamlConfiguration samlConfiguration) {
            Object oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration;
            handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
            return this;
        }

        @Override
        public WebExperienceAuthConfiguration build() {
            return new WebExperienceAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WebExperienceAuthConfiguration#type()
     */
    public enum Type {
        SAML_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
