/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.TextSegment;
import software.amazon.awssdk.services.qbusiness.model.TextSegmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceAttribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceAttribution> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(SourceAttribution.getter(SourceAttribution::title)).setter(SourceAttribution.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> SNIPPET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snippet").getter(SourceAttribution.getter(SourceAttribution::snippet)).setter(SourceAttribution.setter(Builder::snippet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snippet").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(SourceAttribution.getter(SourceAttribution::url)).setter(SourceAttribution.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Integer> CITATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("citationNumber").getter(SourceAttribution.getter(SourceAttribution::citationNumber)).setter(SourceAttribution.setter(Builder::citationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationNumber").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(SourceAttribution.getter(SourceAttribution::updatedAt)).setter(SourceAttribution.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<List<TextSegment>> TEXT_MESSAGE_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("textMessageSegments").getter(SourceAttribution.getter(SourceAttribution::textMessageSegments)).setter(SourceAttribution.setter(Builder::textMessageSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textMessageSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SNIPPET_FIELD, URL_FIELD, CITATION_NUMBER_FIELD, UPDATED_AT_FIELD, TEXT_MESSAGE_SEGMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String snippet;
    private final String url;
    private final Integer citationNumber;
    private final Instant updatedAt;
    private final List<TextSegment> textMessageSegments;

    private SourceAttribution(BuilderImpl builder) {
        this.title = builder.title;
        this.snippet = builder.snippet;
        this.url = builder.url;
        this.citationNumber = builder.citationNumber;
        this.updatedAt = builder.updatedAt;
        this.textMessageSegments = builder.textMessageSegments;
    }

    public final String title() {
        return this.title;
    }

    public final String snippet() {
        return this.snippet;
    }

    public final String url() {
        return this.url;
    }

    public final Integer citationNumber() {
        return this.citationNumber;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTextMessageSegments() {
        return this.textMessageSegments != null && !(this.textMessageSegments instanceof SdkAutoConstructList);
    }

    public final List<TextSegment> textMessageSegments() {
        return this.textMessageSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.snippet());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.citationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextMessageSegments() ? this.textMessageSegments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAttribution)) {
            return false;
        }
        SourceAttribution other = (SourceAttribution)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.snippet(), other.snippet()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.citationNumber(), other.citationNumber()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTextMessageSegments() == other.hasTextMessageSegments() && Objects.equals(this.textMessageSegments(), other.textMessageSegments());
    }

    public final String toString() {
        return ToString.builder((String)"SourceAttribution").add("Title", (Object)this.title()).add("Snippet", (Object)this.snippet()).add("Url", (Object)this.url()).add("CitationNumber", (Object)this.citationNumber()).add("UpdatedAt", (Object)this.updatedAt()).add("TextMessageSegments", this.hasTextMessageSegments() ? this.textMessageSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "snippet": {
                return Optional.ofNullable(clazz.cast(this.snippet()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "citationNumber": {
                return Optional.ofNullable(clazz.cast(this.citationNumber()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "textMessageSegments": {
                return Optional.ofNullable(clazz.cast(this.textMessageSegments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAttribution, T> g) {
        return obj -> g.apply((SourceAttribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String snippet;
        private String url;
        private Integer citationNumber;
        private Instant updatedAt;
        private List<TextSegment> textMessageSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAttribution model) {
            this.title(model.title);
            this.snippet(model.snippet);
            this.url(model.url);
            this.citationNumber(model.citationNumber);
            this.updatedAt(model.updatedAt);
            this.textMessageSegments(model.textMessageSegments);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSnippet() {
            return this.snippet;
        }

        public final void setSnippet(String snippet) {
            this.snippet = snippet;
        }

        @Override
        public final Builder snippet(String snippet) {
            this.snippet = snippet;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getCitationNumber() {
            return this.citationNumber;
        }

        public final void setCitationNumber(Integer citationNumber) {
            this.citationNumber = citationNumber;
        }

        @Override
        public final Builder citationNumber(Integer citationNumber) {
            this.citationNumber = citationNumber;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<TextSegment.Builder> getTextMessageSegments() {
            List<TextSegment.Builder> result = TextSegmentListCopier.copyToBuilder(this.textMessageSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextMessageSegments(Collection<TextSegment.BuilderImpl> textMessageSegments) {
            this.textMessageSegments = TextSegmentListCopier.copyFromBuilder(textMessageSegments);
        }

        @Override
        public final Builder textMessageSegments(Collection<TextSegment> textMessageSegments) {
            this.textMessageSegments = TextSegmentListCopier.copy(textMessageSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textMessageSegments(TextSegment ... textMessageSegments) {
            this.textMessageSegments(Arrays.asList(textMessageSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textMessageSegments(Consumer<TextSegment.Builder> ... textMessageSegments) {
            this.textMessageSegments(Stream.of(textMessageSegments).map(c -> (TextSegment)((TextSegment.Builder)TextSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SourceAttribution build() {
            return new SourceAttribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceAttribution> {
        public Builder title(String var1);

        public Builder snippet(String var1);

        public Builder url(String var1);

        public Builder citationNumber(Integer var1);

        public Builder updatedAt(Instant var1);

        public Builder textMessageSegments(Collection<TextSegment> var1);

        public Builder textMessageSegments(TextSegment ... var1);

        public Builder textMessageSegments(Consumer<TextSegment.Builder> ... var1);
    }
}

