/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.KendraIndexConfiguration;
import software.amazon.awssdk.services.qbusiness.model.NativeIndexConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieverConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrieverConfiguration> {
    private static final SdkField<NativeIndexConfiguration> NATIVE_INDEX_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nativeIndexConfiguration").getter(RetrieverConfiguration.getter(RetrieverConfiguration::nativeIndexConfiguration)).setter(RetrieverConfiguration.setter(Builder::nativeIndexConfiguration)).constructor(NativeIndexConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nativeIndexConfiguration").build()}).build();
    private static final SdkField<KendraIndexConfiguration> KENDRA_INDEX_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kendraIndexConfiguration").getter(RetrieverConfiguration.getter(RetrieverConfiguration::kendraIndexConfiguration)).setter(RetrieverConfiguration.setter(Builder::kendraIndexConfiguration)).constructor(KendraIndexConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndexConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NATIVE_INDEX_CONFIGURATION_FIELD, KENDRA_INDEX_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nativeIndexConfiguration", NATIVE_INDEX_CONFIGURATION_FIELD);
            this.put("kendraIndexConfiguration", KENDRA_INDEX_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final NativeIndexConfiguration nativeIndexConfiguration;
    private final KendraIndexConfiguration kendraIndexConfiguration;
    private final Type type;

    private RetrieverConfiguration(BuilderImpl builder) {
        this.nativeIndexConfiguration = builder.nativeIndexConfiguration;
        this.kendraIndexConfiguration = builder.kendraIndexConfiguration;
        this.type = builder.type;
    }

    public final NativeIndexConfiguration nativeIndexConfiguration() {
        return this.nativeIndexConfiguration;
    }

    public final KendraIndexConfiguration kendraIndexConfiguration() {
        return this.kendraIndexConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeIndexConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraIndexConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieverConfiguration)) {
            return false;
        }
        RetrieverConfiguration other = (RetrieverConfiguration)obj;
        return Objects.equals(this.nativeIndexConfiguration(), other.nativeIndexConfiguration()) && Objects.equals(this.kendraIndexConfiguration(), other.kendraIndexConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieverConfiguration").add("NativeIndexConfiguration", (Object)this.nativeIndexConfiguration()).add("KendraIndexConfiguration", (Object)this.kendraIndexConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nativeIndexConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nativeIndexConfiguration()));
            }
            case "kendraIndexConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kendraIndexConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static RetrieverConfiguration fromNativeIndexConfiguration(NativeIndexConfiguration nativeIndexConfiguration) {
        return (RetrieverConfiguration)RetrieverConfiguration.builder().nativeIndexConfiguration(nativeIndexConfiguration).build();
    }

    public static RetrieverConfiguration fromNativeIndexConfiguration(Consumer<NativeIndexConfiguration.Builder> nativeIndexConfiguration) {
        NativeIndexConfiguration.Builder builder = NativeIndexConfiguration.builder();
        nativeIndexConfiguration.accept(builder);
        return RetrieverConfiguration.fromNativeIndexConfiguration((NativeIndexConfiguration)builder.build());
    }

    public static RetrieverConfiguration fromKendraIndexConfiguration(KendraIndexConfiguration kendraIndexConfiguration) {
        return (RetrieverConfiguration)RetrieverConfiguration.builder().kendraIndexConfiguration(kendraIndexConfiguration).build();
    }

    public static RetrieverConfiguration fromKendraIndexConfiguration(Consumer<KendraIndexConfiguration.Builder> kendraIndexConfiguration) {
        KendraIndexConfiguration.Builder builder = KendraIndexConfiguration.builder();
        kendraIndexConfiguration.accept(builder);
        return RetrieverConfiguration.fromKendraIndexConfiguration((KendraIndexConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrieverConfiguration, T> g) {
        return obj -> g.apply((RetrieverConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NATIVE_INDEX_CONFIGURATION,
        KENDRA_INDEX_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NativeIndexConfiguration nativeIndexConfiguration;
        private KendraIndexConfiguration kendraIndexConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieverConfiguration model) {
            this.nativeIndexConfiguration(model.nativeIndexConfiguration);
            this.kendraIndexConfiguration(model.kendraIndexConfiguration);
        }

        public final NativeIndexConfiguration.Builder getNativeIndexConfiguration() {
            return this.nativeIndexConfiguration != null ? this.nativeIndexConfiguration.toBuilder() : null;
        }

        public final void setNativeIndexConfiguration(NativeIndexConfiguration.BuilderImpl nativeIndexConfiguration) {
            NativeIndexConfiguration oldValue = this.nativeIndexConfiguration;
            this.nativeIndexConfiguration = nativeIndexConfiguration != null ? nativeIndexConfiguration.build() : null;
            this.handleUnionValueChange(Type.NATIVE_INDEX_CONFIGURATION, oldValue, this.nativeIndexConfiguration);
        }

        @Override
        public final Builder nativeIndexConfiguration(NativeIndexConfiguration nativeIndexConfiguration) {
            NativeIndexConfiguration oldValue = this.nativeIndexConfiguration;
            this.nativeIndexConfiguration = nativeIndexConfiguration;
            this.handleUnionValueChange(Type.NATIVE_INDEX_CONFIGURATION, oldValue, this.nativeIndexConfiguration);
            return this;
        }

        public final KendraIndexConfiguration.Builder getKendraIndexConfiguration() {
            return this.kendraIndexConfiguration != null ? this.kendraIndexConfiguration.toBuilder() : null;
        }

        public final void setKendraIndexConfiguration(KendraIndexConfiguration.BuilderImpl kendraIndexConfiguration) {
            KendraIndexConfiguration oldValue = this.kendraIndexConfiguration;
            this.kendraIndexConfiguration = kendraIndexConfiguration != null ? kendraIndexConfiguration.build() : null;
            this.handleUnionValueChange(Type.KENDRA_INDEX_CONFIGURATION, oldValue, this.kendraIndexConfiguration);
        }

        @Override
        public final Builder kendraIndexConfiguration(KendraIndexConfiguration kendraIndexConfiguration) {
            KendraIndexConfiguration oldValue = this.kendraIndexConfiguration;
            this.kendraIndexConfiguration = kendraIndexConfiguration;
            this.handleUnionValueChange(Type.KENDRA_INDEX_CONFIGURATION, oldValue, this.kendraIndexConfiguration);
            return this;
        }

        public RetrieverConfiguration build() {
            return new RetrieverConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrieverConfiguration> {
        public Builder nativeIndexConfiguration(NativeIndexConfiguration var1);

        default public Builder nativeIndexConfiguration(Consumer<NativeIndexConfiguration.Builder> nativeIndexConfiguration) {
            return this.nativeIndexConfiguration((NativeIndexConfiguration)((NativeIndexConfiguration.Builder)NativeIndexConfiguration.builder().applyMutation(nativeIndexConfiguration)).build());
        }

        public Builder kendraIndexConfiguration(KendraIndexConfiguration var1);

        default public Builder kendraIndexConfiguration(Consumer<KendraIndexConfiguration.Builder> kendraIndexConfiguration) {
            return this.kendraIndexConfiguration((KendraIndexConfiguration)((KendraIndexConfiguration.Builder)KendraIndexConfiguration.builder().applyMutation(kendraIndexConfiguration)).build());
        }
    }
}

