/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.MembershipType;
import software.amazon.awssdk.services.qbusiness.model.ReadAccessType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalUser> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PrincipalUser.getter(PrincipalUser::id)).setter(PrincipalUser.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("access").getter(PrincipalUser.getter(PrincipalUser::accessAsString)).setter(PrincipalUser.setter(Builder::access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build()}).build();
    private static final SdkField<String> MEMBERSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipType").getter(PrincipalUser.getter(PrincipalUser::membershipTypeAsString)).setter(PrincipalUser.setter(Builder::membershipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCESS_FIELD, MEMBERSHIP_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("access", ACCESS_FIELD);
            this.put("membershipType", MEMBERSHIP_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String access;
    private final String membershipType;

    private PrincipalUser(BuilderImpl builder) {
        this.id = builder.id;
        this.access = builder.access;
        this.membershipType = builder.membershipType;
    }

    public final String id() {
        return this.id;
    }

    public final ReadAccessType access() {
        return ReadAccessType.fromValue(this.access);
    }

    public final String accessAsString() {
        return this.access;
    }

    public final MembershipType membershipType() {
        return MembershipType.fromValue(this.membershipType);
    }

    public final String membershipTypeAsString() {
        return this.membershipType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalUser)) {
            return false;
        }
        PrincipalUser other = (PrincipalUser)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.accessAsString(), other.accessAsString()) && Objects.equals(this.membershipTypeAsString(), other.membershipTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalUser").add("Id", (Object)this.id()).add("Access", (Object)this.accessAsString()).add("MembershipType", (Object)this.membershipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "access": {
                return Optional.ofNullable(clazz.cast(this.accessAsString()));
            }
            case "membershipType": {
                return Optional.ofNullable(clazz.cast(this.membershipTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalUser, T> g) {
        return obj -> g.apply((PrincipalUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String access;
        private String membershipType;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalUser model) {
            this.id(model.id);
            this.access(model.access);
            this.membershipType(model.membershipType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAccess() {
            return this.access;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ReadAccessType access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        public final String getMembershipType() {
            return this.membershipType;
        }

        public final void setMembershipType(String membershipType) {
            this.membershipType = membershipType;
        }

        @Override
        public final Builder membershipType(String membershipType) {
            this.membershipType = membershipType;
            return this;
        }

        @Override
        public final Builder membershipType(MembershipType membershipType) {
            this.membershipType(membershipType == null ? null : membershipType.toString());
            return this;
        }

        public PrincipalUser build() {
            return new PrincipalUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalUser> {
        public Builder id(String var1);

        public Builder access(String var1);

        public Builder access(ReadAccessType var1);

        public Builder membershipType(String var1);

        public Builder membershipType(MembershipType var1);
    }
}

