/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.RuleConfiguration;
import software.amazon.awssdk.services.qbusiness.model.RuleType;
import software.amazon.awssdk.services.qbusiness.model.UsersAndGroups;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<UsersAndGroups> INCLUDED_USERS_AND_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includedUsersAndGroups").getter(Rule.getter(Rule::includedUsersAndGroups)).setter(Rule.setter(Builder::includedUsersAndGroups)).constructor(UsersAndGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedUsersAndGroups").build()}).build();
    private static final SdkField<UsersAndGroups> EXCLUDED_USERS_AND_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("excludedUsersAndGroups").getter(Rule.getter(Rule::excludedUsersAndGroups)).setter(Rule.setter(Builder::excludedUsersAndGroups)).constructor(UsersAndGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedUsersAndGroups").build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleType").getter(Rule.getter(Rule::ruleTypeAsString)).setter(Rule.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()}).build();
    private static final SdkField<RuleConfiguration> RULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ruleConfiguration").getter(Rule.getter(Rule::ruleConfiguration)).setter(Rule.setter(Builder::ruleConfiguration)).constructor(RuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_USERS_AND_GROUPS_FIELD, EXCLUDED_USERS_AND_GROUPS_FIELD, RULE_TYPE_FIELD, RULE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("includedUsersAndGroups", INCLUDED_USERS_AND_GROUPS_FIELD);
            this.put("excludedUsersAndGroups", EXCLUDED_USERS_AND_GROUPS_FIELD);
            this.put("ruleType", RULE_TYPE_FIELD);
            this.put("ruleConfiguration", RULE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final UsersAndGroups includedUsersAndGroups;
    private final UsersAndGroups excludedUsersAndGroups;
    private final String ruleType;
    private final RuleConfiguration ruleConfiguration;

    private Rule(BuilderImpl builder) {
        this.includedUsersAndGroups = builder.includedUsersAndGroups;
        this.excludedUsersAndGroups = builder.excludedUsersAndGroups;
        this.ruleType = builder.ruleType;
        this.ruleConfiguration = builder.ruleConfiguration;
    }

    public final UsersAndGroups includedUsersAndGroups() {
        return this.includedUsersAndGroups;
    }

    public final UsersAndGroups excludedUsersAndGroups() {
        return this.excludedUsersAndGroups;
    }

    public final RuleType ruleType() {
        return RuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final RuleConfiguration ruleConfiguration() {
        return this.ruleConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includedUsersAndGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedUsersAndGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.includedUsersAndGroups(), other.includedUsersAndGroups()) && Objects.equals(this.excludedUsersAndGroups(), other.excludedUsersAndGroups()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.ruleConfiguration(), other.ruleConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("IncludedUsersAndGroups", (Object)this.includedUsersAndGroups()).add("ExcludedUsersAndGroups", (Object)this.excludedUsersAndGroups()).add("RuleType", (Object)this.ruleTypeAsString()).add("RuleConfiguration", (Object)this.ruleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includedUsersAndGroups": {
                return Optional.ofNullable(clazz.cast(this.includedUsersAndGroups()));
            }
            case "excludedUsersAndGroups": {
                return Optional.ofNullable(clazz.cast(this.excludedUsersAndGroups()));
            }
            case "ruleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "ruleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ruleConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UsersAndGroups includedUsersAndGroups;
        private UsersAndGroups excludedUsersAndGroups;
        private String ruleType;
        private RuleConfiguration ruleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.includedUsersAndGroups(model.includedUsersAndGroups);
            this.excludedUsersAndGroups(model.excludedUsersAndGroups);
            this.ruleType(model.ruleType);
            this.ruleConfiguration(model.ruleConfiguration);
        }

        public final UsersAndGroups.Builder getIncludedUsersAndGroups() {
            return this.includedUsersAndGroups != null ? this.includedUsersAndGroups.toBuilder() : null;
        }

        public final void setIncludedUsersAndGroups(UsersAndGroups.BuilderImpl includedUsersAndGroups) {
            this.includedUsersAndGroups = includedUsersAndGroups != null ? includedUsersAndGroups.build() : null;
        }

        @Override
        public final Builder includedUsersAndGroups(UsersAndGroups includedUsersAndGroups) {
            this.includedUsersAndGroups = includedUsersAndGroups;
            return this;
        }

        public final UsersAndGroups.Builder getExcludedUsersAndGroups() {
            return this.excludedUsersAndGroups != null ? this.excludedUsersAndGroups.toBuilder() : null;
        }

        public final void setExcludedUsersAndGroups(UsersAndGroups.BuilderImpl excludedUsersAndGroups) {
            this.excludedUsersAndGroups = excludedUsersAndGroups != null ? excludedUsersAndGroups.build() : null;
        }

        @Override
        public final Builder excludedUsersAndGroups(UsersAndGroups excludedUsersAndGroups) {
            this.excludedUsersAndGroups = excludedUsersAndGroups;
            return this;
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final RuleConfiguration.Builder getRuleConfiguration() {
            return this.ruleConfiguration != null ? this.ruleConfiguration.toBuilder() : null;
        }

        public final void setRuleConfiguration(RuleConfiguration.BuilderImpl ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration != null ? ruleConfiguration.build() : null;
        }

        @Override
        public final Builder ruleConfiguration(RuleConfiguration ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder includedUsersAndGroups(UsersAndGroups var1);

        default public Builder includedUsersAndGroups(Consumer<UsersAndGroups.Builder> includedUsersAndGroups) {
            return this.includedUsersAndGroups((UsersAndGroups)((UsersAndGroups.Builder)UsersAndGroups.builder().applyMutation(includedUsersAndGroups)).build());
        }

        public Builder excludedUsersAndGroups(UsersAndGroups var1);

        default public Builder excludedUsersAndGroups(Consumer<UsersAndGroups.Builder> excludedUsersAndGroups) {
            return this.excludedUsersAndGroups((UsersAndGroups)((UsersAndGroups.Builder)UsersAndGroups.builder().applyMutation(excludedUsersAndGroups)).build());
        }

        public Builder ruleType(String var1);

        public Builder ruleType(RuleType var1);

        public Builder ruleConfiguration(RuleConfiguration var1);

        default public Builder ruleConfiguration(Consumer<RuleConfiguration.Builder> ruleConfiguration) {
            return this.ruleConfiguration((RuleConfiguration)((RuleConfiguration.Builder)RuleConfiguration.builder().applyMutation(ruleConfiguration)).build());
        }
    }
}

