/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.DateAttributeBoostingConfiguration;
import software.amazon.awssdk.services.qbusiness.model.NumberAttributeBoostingConfiguration;
import software.amazon.awssdk.services.qbusiness.model.StringAttributeBoostingConfiguration;
import software.amazon.awssdk.services.qbusiness.model.StringListAttributeBoostingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeBoostingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeBoostingConfiguration> {
    private static final SdkField<NumberAttributeBoostingConfiguration> NUMBER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("numberConfiguration").getter(DocumentAttributeBoostingConfiguration.getter(DocumentAttributeBoostingConfiguration::numberConfiguration)).setter(DocumentAttributeBoostingConfiguration.setter(Builder::numberConfiguration)).constructor(NumberAttributeBoostingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberConfiguration").build()}).build();
    private static final SdkField<StringAttributeBoostingConfiguration> STRING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stringConfiguration").getter(DocumentAttributeBoostingConfiguration.getter(DocumentAttributeBoostingConfiguration::stringConfiguration)).setter(DocumentAttributeBoostingConfiguration.setter(Builder::stringConfiguration)).constructor(StringAttributeBoostingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringConfiguration").build()}).build();
    private static final SdkField<DateAttributeBoostingConfiguration> DATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dateConfiguration").getter(DocumentAttributeBoostingConfiguration.getter(DocumentAttributeBoostingConfiguration::dateConfiguration)).setter(DocumentAttributeBoostingConfiguration.setter(Builder::dateConfiguration)).constructor(DateAttributeBoostingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateConfiguration").build()}).build();
    private static final SdkField<StringListAttributeBoostingConfiguration> STRING_LIST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stringListConfiguration").getter(DocumentAttributeBoostingConfiguration.getter(DocumentAttributeBoostingConfiguration::stringListConfiguration)).setter(DocumentAttributeBoostingConfiguration.setter(Builder::stringListConfiguration)).constructor(StringListAttributeBoostingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringListConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_CONFIGURATION_FIELD, STRING_CONFIGURATION_FIELD, DATE_CONFIGURATION_FIELD, STRING_LIST_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("numberConfiguration", NUMBER_CONFIGURATION_FIELD);
            this.put("stringConfiguration", STRING_CONFIGURATION_FIELD);
            this.put("dateConfiguration", DATE_CONFIGURATION_FIELD);
            this.put("stringListConfiguration", STRING_LIST_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final NumberAttributeBoostingConfiguration numberConfiguration;
    private final StringAttributeBoostingConfiguration stringConfiguration;
    private final DateAttributeBoostingConfiguration dateConfiguration;
    private final StringListAttributeBoostingConfiguration stringListConfiguration;
    private final Type type;

    private DocumentAttributeBoostingConfiguration(BuilderImpl builder) {
        this.numberConfiguration = builder.numberConfiguration;
        this.stringConfiguration = builder.stringConfiguration;
        this.dateConfiguration = builder.dateConfiguration;
        this.stringListConfiguration = builder.stringListConfiguration;
        this.type = builder.type;
    }

    public final NumberAttributeBoostingConfiguration numberConfiguration() {
        return this.numberConfiguration;
    }

    public final StringAttributeBoostingConfiguration stringConfiguration() {
        return this.stringConfiguration;
    }

    public final DateAttributeBoostingConfiguration dateConfiguration() {
        return this.dateConfiguration;
    }

    public final StringListAttributeBoostingConfiguration stringListConfiguration() {
        return this.stringListConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringListConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeBoostingConfiguration)) {
            return false;
        }
        DocumentAttributeBoostingConfiguration other = (DocumentAttributeBoostingConfiguration)obj;
        return Objects.equals(this.numberConfiguration(), other.numberConfiguration()) && Objects.equals(this.stringConfiguration(), other.stringConfiguration()) && Objects.equals(this.dateConfiguration(), other.dateConfiguration()) && Objects.equals(this.stringListConfiguration(), other.stringListConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeBoostingConfiguration").add("NumberConfiguration", (Object)this.numberConfiguration()).add("StringConfiguration", (Object)this.stringConfiguration()).add("DateConfiguration", (Object)this.dateConfiguration()).add("StringListConfiguration", (Object)this.stringListConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberConfiguration": {
                return Optional.ofNullable(clazz.cast(this.numberConfiguration()));
            }
            case "stringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stringConfiguration()));
            }
            case "dateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dateConfiguration()));
            }
            case "stringListConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stringListConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static DocumentAttributeBoostingConfiguration fromNumberConfiguration(NumberAttributeBoostingConfiguration numberConfiguration) {
        return (DocumentAttributeBoostingConfiguration)DocumentAttributeBoostingConfiguration.builder().numberConfiguration(numberConfiguration).build();
    }

    public static DocumentAttributeBoostingConfiguration fromNumberConfiguration(Consumer<NumberAttributeBoostingConfiguration.Builder> numberConfiguration) {
        NumberAttributeBoostingConfiguration.Builder builder = NumberAttributeBoostingConfiguration.builder();
        numberConfiguration.accept(builder);
        return DocumentAttributeBoostingConfiguration.fromNumberConfiguration((NumberAttributeBoostingConfiguration)builder.build());
    }

    public static DocumentAttributeBoostingConfiguration fromStringConfiguration(StringAttributeBoostingConfiguration stringConfiguration) {
        return (DocumentAttributeBoostingConfiguration)DocumentAttributeBoostingConfiguration.builder().stringConfiguration(stringConfiguration).build();
    }

    public static DocumentAttributeBoostingConfiguration fromStringConfiguration(Consumer<StringAttributeBoostingConfiguration.Builder> stringConfiguration) {
        StringAttributeBoostingConfiguration.Builder builder = StringAttributeBoostingConfiguration.builder();
        stringConfiguration.accept(builder);
        return DocumentAttributeBoostingConfiguration.fromStringConfiguration((StringAttributeBoostingConfiguration)builder.build());
    }

    public static DocumentAttributeBoostingConfiguration fromDateConfiguration(DateAttributeBoostingConfiguration dateConfiguration) {
        return (DocumentAttributeBoostingConfiguration)DocumentAttributeBoostingConfiguration.builder().dateConfiguration(dateConfiguration).build();
    }

    public static DocumentAttributeBoostingConfiguration fromDateConfiguration(Consumer<DateAttributeBoostingConfiguration.Builder> dateConfiguration) {
        DateAttributeBoostingConfiguration.Builder builder = DateAttributeBoostingConfiguration.builder();
        dateConfiguration.accept(builder);
        return DocumentAttributeBoostingConfiguration.fromDateConfiguration((DateAttributeBoostingConfiguration)builder.build());
    }

    public static DocumentAttributeBoostingConfiguration fromStringListConfiguration(StringListAttributeBoostingConfiguration stringListConfiguration) {
        return (DocumentAttributeBoostingConfiguration)DocumentAttributeBoostingConfiguration.builder().stringListConfiguration(stringListConfiguration).build();
    }

    public static DocumentAttributeBoostingConfiguration fromStringListConfiguration(Consumer<StringListAttributeBoostingConfiguration.Builder> stringListConfiguration) {
        StringListAttributeBoostingConfiguration.Builder builder = StringListAttributeBoostingConfiguration.builder();
        stringListConfiguration.accept(builder);
        return DocumentAttributeBoostingConfiguration.fromStringListConfiguration((StringListAttributeBoostingConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((DocumentAttributeBoostingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NUMBER_CONFIGURATION,
        STRING_CONFIGURATION,
        DATE_CONFIGURATION,
        STRING_LIST_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NumberAttributeBoostingConfiguration numberConfiguration;
        private StringAttributeBoostingConfiguration stringConfiguration;
        private DateAttributeBoostingConfiguration dateConfiguration;
        private StringListAttributeBoostingConfiguration stringListConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeBoostingConfiguration model) {
            this.numberConfiguration(model.numberConfiguration);
            this.stringConfiguration(model.stringConfiguration);
            this.dateConfiguration(model.dateConfiguration);
            this.stringListConfiguration(model.stringListConfiguration);
        }

        public final NumberAttributeBoostingConfiguration.Builder getNumberConfiguration() {
            return this.numberConfiguration != null ? this.numberConfiguration.toBuilder() : null;
        }

        public final void setNumberConfiguration(NumberAttributeBoostingConfiguration.BuilderImpl numberConfiguration) {
            NumberAttributeBoostingConfiguration oldValue = this.numberConfiguration;
            this.numberConfiguration = numberConfiguration != null ? numberConfiguration.build() : null;
            this.handleUnionValueChange(Type.NUMBER_CONFIGURATION, oldValue, this.numberConfiguration);
        }

        @Override
        public final Builder numberConfiguration(NumberAttributeBoostingConfiguration numberConfiguration) {
            NumberAttributeBoostingConfiguration oldValue = this.numberConfiguration;
            this.numberConfiguration = numberConfiguration;
            this.handleUnionValueChange(Type.NUMBER_CONFIGURATION, oldValue, this.numberConfiguration);
            return this;
        }

        public final StringAttributeBoostingConfiguration.Builder getStringConfiguration() {
            return this.stringConfiguration != null ? this.stringConfiguration.toBuilder() : null;
        }

        public final void setStringConfiguration(StringAttributeBoostingConfiguration.BuilderImpl stringConfiguration) {
            StringAttributeBoostingConfiguration oldValue = this.stringConfiguration;
            this.stringConfiguration = stringConfiguration != null ? stringConfiguration.build() : null;
            this.handleUnionValueChange(Type.STRING_CONFIGURATION, oldValue, this.stringConfiguration);
        }

        @Override
        public final Builder stringConfiguration(StringAttributeBoostingConfiguration stringConfiguration) {
            StringAttributeBoostingConfiguration oldValue = this.stringConfiguration;
            this.stringConfiguration = stringConfiguration;
            this.handleUnionValueChange(Type.STRING_CONFIGURATION, oldValue, this.stringConfiguration);
            return this;
        }

        public final DateAttributeBoostingConfiguration.Builder getDateConfiguration() {
            return this.dateConfiguration != null ? this.dateConfiguration.toBuilder() : null;
        }

        public final void setDateConfiguration(DateAttributeBoostingConfiguration.BuilderImpl dateConfiguration) {
            DateAttributeBoostingConfiguration oldValue = this.dateConfiguration;
            this.dateConfiguration = dateConfiguration != null ? dateConfiguration.build() : null;
            this.handleUnionValueChange(Type.DATE_CONFIGURATION, oldValue, this.dateConfiguration);
        }

        @Override
        public final Builder dateConfiguration(DateAttributeBoostingConfiguration dateConfiguration) {
            DateAttributeBoostingConfiguration oldValue = this.dateConfiguration;
            this.dateConfiguration = dateConfiguration;
            this.handleUnionValueChange(Type.DATE_CONFIGURATION, oldValue, this.dateConfiguration);
            return this;
        }

        public final StringListAttributeBoostingConfiguration.Builder getStringListConfiguration() {
            return this.stringListConfiguration != null ? this.stringListConfiguration.toBuilder() : null;
        }

        public final void setStringListConfiguration(StringListAttributeBoostingConfiguration.BuilderImpl stringListConfiguration) {
            StringListAttributeBoostingConfiguration oldValue = this.stringListConfiguration;
            this.stringListConfiguration = stringListConfiguration != null ? stringListConfiguration.build() : null;
            this.handleUnionValueChange(Type.STRING_LIST_CONFIGURATION, oldValue, this.stringListConfiguration);
        }

        @Override
        public final Builder stringListConfiguration(StringListAttributeBoostingConfiguration stringListConfiguration) {
            StringListAttributeBoostingConfiguration oldValue = this.stringListConfiguration;
            this.stringListConfiguration = stringListConfiguration;
            this.handleUnionValueChange(Type.STRING_LIST_CONFIGURATION, oldValue, this.stringListConfiguration);
            return this;
        }

        public DocumentAttributeBoostingConfiguration build() {
            return new DocumentAttributeBoostingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeBoostingConfiguration> {
        public Builder numberConfiguration(NumberAttributeBoostingConfiguration var1);

        default public Builder numberConfiguration(Consumer<NumberAttributeBoostingConfiguration.Builder> numberConfiguration) {
            return this.numberConfiguration((NumberAttributeBoostingConfiguration)((NumberAttributeBoostingConfiguration.Builder)NumberAttributeBoostingConfiguration.builder().applyMutation(numberConfiguration)).build());
        }

        public Builder stringConfiguration(StringAttributeBoostingConfiguration var1);

        default public Builder stringConfiguration(Consumer<StringAttributeBoostingConfiguration.Builder> stringConfiguration) {
            return this.stringConfiguration((StringAttributeBoostingConfiguration)((StringAttributeBoostingConfiguration.Builder)StringAttributeBoostingConfiguration.builder().applyMutation(stringConfiguration)).build());
        }

        public Builder dateConfiguration(DateAttributeBoostingConfiguration var1);

        default public Builder dateConfiguration(Consumer<DateAttributeBoostingConfiguration.Builder> dateConfiguration) {
            return this.dateConfiguration((DateAttributeBoostingConfiguration)((DateAttributeBoostingConfiguration.Builder)DateAttributeBoostingConfiguration.builder().applyMutation(dateConfiguration)).build());
        }

        public Builder stringListConfiguration(StringListAttributeBoostingConfiguration var1);

        default public Builder stringListConfiguration(Consumer<StringListAttributeBoostingConfiguration.Builder> stringListConfiguration) {
            return this.stringListConfiguration((StringListAttributeBoostingConfiguration)((StringListAttributeBoostingConfiguration.Builder)StringListAttributeBoostingConfiguration.builder().applyMutation(stringListConfiguration)).build());
        }
    }
}

