/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.Conversation;
import software.amazon.awssdk.services.qbusiness.model.ConversationsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConversationsResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListConversationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConversationsResponse.getter(ListConversationsResponse::nextToken)).setter(ListConversationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Conversation>> CONVERSATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conversations").getter(ListConversationsResponse.getter(ListConversationsResponse::conversations)).setter(ListConversationsResponse.setter(Builder::conversations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Conversation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONVERSATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("conversations", CONVERSATIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<Conversation> conversations;

    private ListConversationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.conversations = builder.conversations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConversations() {
        return this.conversations != null && !(this.conversations instanceof SdkAutoConstructList);
    }

    public final List<Conversation> conversations() {
        return this.conversations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConversations() ? this.conversations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConversationsResponse)) {
            return false;
        }
        ListConversationsResponse other = (ListConversationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConversations() == other.hasConversations() && Objects.equals(this.conversations(), other.conversations());
    }

    public final String toString() {
        return ToString.builder((String)"ListConversationsResponse").add("NextToken", (Object)this.nextToken()).add("Conversations", this.hasConversations() ? this.conversations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "conversations": {
                return Optional.ofNullable(clazz.cast(this.conversations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConversationsResponse, T> g) {
        return obj -> g.apply((ListConversationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Conversation> conversations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConversationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.conversations(model.conversations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Conversation.Builder> getConversations() {
            List<Conversation.Builder> result = ConversationsCopier.copyToBuilder(this.conversations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversations(Collection<Conversation.BuilderImpl> conversations) {
            this.conversations = ConversationsCopier.copyFromBuilder(conversations);
        }

        @Override
        public final Builder conversations(Collection<Conversation> conversations) {
            this.conversations = ConversationsCopier.copy(conversations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversations(Conversation ... conversations) {
            this.conversations(Arrays.asList(conversations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversations(Consumer<Conversation.Builder> ... conversations) {
            this.conversations(Stream.of(conversations).map(c -> (Conversation)((Conversation.Builder)Conversation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConversationsResponse build() {
            return new ListConversationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConversationsResponse> {
        public Builder nextToken(String var1);

        public Builder conversations(Collection<Conversation> var1);

        public Builder conversations(Conversation ... var1);

        public Builder conversations(Consumer<Conversation.Builder> ... var1);
    }
}

