/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.RetrieverStatus;
import software.amazon.awssdk.services.qbusiness.model.RetrieverType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Retriever
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Retriever> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(Retriever.getter(Retriever::applicationId)).setter(Retriever.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrieverId").getter(Retriever.getter(Retriever::retrieverId)).setter(Retriever.setter(Builder::retrieverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Retriever.getter(Retriever::typeAsString)).setter(Retriever.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Retriever.getter(Retriever::statusAsString)).setter(Retriever.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(Retriever.getter(Retriever::displayName)).setter(Retriever.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RETRIEVER_ID_FIELD, TYPE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("retrieverId", RETRIEVER_ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String retrieverId;
    private final String type;
    private final String status;
    private final String displayName;

    private Retriever(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.retrieverId = builder.retrieverId;
        this.type = builder.type;
        this.status = builder.status;
        this.displayName = builder.displayName;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String retrieverId() {
        return this.retrieverId;
    }

    public final RetrieverType type() {
        return RetrieverType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final RetrieverStatus status() {
        return RetrieverStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Retriever)) {
            return false;
        }
        Retriever other = (Retriever)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.retrieverId(), other.retrieverId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"Retriever").add("ApplicationId", (Object)this.applicationId()).add("RetrieverId", (Object)this.retrieverId()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "retrieverId": {
                return Optional.ofNullable(clazz.cast(this.retrieverId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Retriever, T> g) {
        return obj -> g.apply((Retriever)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String retrieverId;
        private String type;
        private String status;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Retriever model) {
            this.applicationId(model.applicationId);
            this.retrieverId(model.retrieverId);
            this.type(model.type);
            this.status(model.status);
            this.displayName(model.displayName);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRetrieverId() {
            return this.retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrieverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Retriever build() {
            return new Retriever(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Retriever> {
        public Builder applicationId(String var1);

        public Builder retrieverId(String var1);

        public Builder type(String var1);

        public Builder type(RetrieverType var1);

        public Builder status(String var1);

        public Builder status(RetrieverStatus var1);

        public Builder displayName(String var1);
    }
}

