/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.ActionFilterConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionConfiguration> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ActionConfiguration.getter(ActionConfiguration::action)).setter(ActionConfiguration.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<ActionFilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterConfiguration").getter(ActionConfiguration.getter(ActionConfiguration::filterConfiguration)).setter(ActionConfiguration.setter(Builder::filterConfiguration)).constructor(ActionFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FILTER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("action", ACTION_FIELD);
            this.put("filterConfiguration", FILTER_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final ActionFilterConfiguration filterConfiguration;

    private ActionConfiguration(BuilderImpl builder) {
        this.action = builder.action;
        this.filterConfiguration = builder.filterConfiguration;
    }

    public final String action() {
        return this.action;
    }

    public final ActionFilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.filterConfiguration(), other.filterConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ActionConfiguration").add("Action", (Object)this.action()).add("FilterConfiguration", (Object)this.filterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "filterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionConfiguration, T> g) {
        return obj -> g.apply((ActionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ActionFilterConfiguration filterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionConfiguration model) {
            this.action(model.action);
            this.filterConfiguration(model.filterConfiguration);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final ActionFilterConfiguration.Builder getFilterConfiguration() {
            return this.filterConfiguration != null ? this.filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(ActionFilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(ActionFilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public ActionConfiguration build() {
            return new ActionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionConfiguration> {
        public Builder action(String var1);

        public Builder filterConfiguration(ActionFilterConfiguration var1);

        default public Builder filterConfiguration(Consumer<ActionFilterConfiguration.Builder> filterConfiguration) {
            return this.filterConfiguration((ActionFilterConfiguration)((ActionFilterConfiguration.Builder)ActionFilterConfiguration.builder().applyMutation(filterConfiguration)).build());
        }
    }
}

