/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.BlockedPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockedPhrasesConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockedPhrasesConfiguration> {
    private static final SdkField<List<String>> BLOCKED_PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedPhrases").getter(BlockedPhrasesConfiguration.getter(BlockedPhrasesConfiguration::blockedPhrases)).setter(BlockedPhrasesConfiguration.setter(Builder::blockedPhrases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageOverride").getter(BlockedPhrasesConfiguration.getter(BlockedPhrasesConfiguration::systemMessageOverride)).setter(BlockedPhrasesConfiguration.setter(Builder::systemMessageOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_PHRASES_FIELD, SYSTEM_MESSAGE_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("blockedPhrases", BLOCKED_PHRASES_FIELD);
            this.put("systemMessageOverride", SYSTEM_MESSAGE_OVERRIDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> blockedPhrases;
    private final String systemMessageOverride;

    private BlockedPhrasesConfiguration(BuilderImpl builder) {
        this.blockedPhrases = builder.blockedPhrases;
        this.systemMessageOverride = builder.systemMessageOverride;
    }

    public final boolean hasBlockedPhrases() {
        return this.blockedPhrases != null && !(this.blockedPhrases instanceof SdkAutoConstructList);
    }

    public final List<String> blockedPhrases() {
        return this.blockedPhrases;
    }

    public final String systemMessageOverride() {
        return this.systemMessageOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedPhrases() ? this.blockedPhrases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockedPhrasesConfiguration)) {
            return false;
        }
        BlockedPhrasesConfiguration other = (BlockedPhrasesConfiguration)obj;
        return this.hasBlockedPhrases() == other.hasBlockedPhrases() && Objects.equals(this.blockedPhrases(), other.blockedPhrases()) && Objects.equals(this.systemMessageOverride(), other.systemMessageOverride());
    }

    public final String toString() {
        return ToString.builder((String)"BlockedPhrasesConfiguration").add("BlockedPhrases", this.hasBlockedPhrases() ? this.blockedPhrases() : null).add("SystemMessageOverride", (Object)this.systemMessageOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blockedPhrases": {
                return Optional.ofNullable(clazz.cast(this.blockedPhrases()));
            }
            case "systemMessageOverride": {
                return Optional.ofNullable(clazz.cast(this.systemMessageOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlockedPhrasesConfiguration, T> g) {
        return obj -> g.apply((BlockedPhrasesConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blockedPhrases = DefaultSdkAutoConstructList.getInstance();
        private String systemMessageOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockedPhrasesConfiguration model) {
            this.blockedPhrases(model.blockedPhrases);
            this.systemMessageOverride(model.systemMessageOverride);
        }

        public final Collection<String> getBlockedPhrases() {
            if (this.blockedPhrases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedPhrases;
        }

        public final void setBlockedPhrases(Collection<String> blockedPhrases) {
            this.blockedPhrases = BlockedPhrasesCopier.copy(blockedPhrases);
        }

        @Override
        public final Builder blockedPhrases(Collection<String> blockedPhrases) {
            this.blockedPhrases = BlockedPhrasesCopier.copy(blockedPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrases(String ... blockedPhrases) {
            this.blockedPhrases(Arrays.asList(blockedPhrases));
            return this;
        }

        public final String getSystemMessageOverride() {
            return this.systemMessageOverride;
        }

        public final void setSystemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
        }

        @Override
        public final Builder systemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
            return this;
        }

        public BlockedPhrasesConfiguration build() {
            return new BlockedPhrasesConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockedPhrasesConfiguration> {
        public Builder blockedPhrases(Collection<String> var1);

        public Builder blockedPhrases(String ... var1);

        public Builder systemMessageOverride(String var1);
    }
}

