/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentType {
    PDF("PDF"),
    HTML("HTML"),
    MS_WORD("MS_WORD"),
    PLAIN_TEXT("PLAIN_TEXT"),
    PPT("PPT"),
    RTF("RTF"),
    XML("XML"),
    XSLT("XSLT"),
    MS_EXCEL("MS_EXCEL"),
    CSV("CSV"),
    JSON("JSON"),
    MD("MD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentType> VALUE_MAP;
    private final String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentType> knownValues() {
        EnumSet<ContentType> knownValues = EnumSet.allOf(ContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentType.class, ContentType::toString);
    }
}

