/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.ConversationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyFromSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyFromSource> {
    private static final SdkField<ConversationSource> CONVERSATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversation").getter(CopyFromSource.getter(CopyFromSource::conversation)).setter(CopyFromSource.setter(Builder::conversation)).constructor(ConversationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("conversation", CONVERSATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ConversationSource conversation;
    private final Type type;

    private CopyFromSource(BuilderImpl builder) {
        this.conversation = builder.conversation;
        this.type = builder.type;
    }

    public final ConversationSource conversation() {
        return this.conversation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFromSource)) {
            return false;
        }
        CopyFromSource other = (CopyFromSource)obj;
        return Objects.equals(this.conversation(), other.conversation());
    }

    public final String toString() {
        return ToString.builder((String)"CopyFromSource").add("Conversation", (Object)this.conversation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversation": {
                return Optional.ofNullable(clazz.cast(this.conversation()));
            }
        }
        return Optional.empty();
    }

    public static CopyFromSource fromConversation(ConversationSource conversation) {
        return (CopyFromSource)CopyFromSource.builder().conversation(conversation).build();
    }

    public static CopyFromSource fromConversation(Consumer<ConversationSource.Builder> conversation) {
        ConversationSource.Builder builder = ConversationSource.builder();
        conversation.accept(builder);
        return CopyFromSource.fromConversation((ConversationSource)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyFromSource, T> g) {
        return obj -> g.apply((CopyFromSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONVERSATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ConversationSource conversation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFromSource model) {
            this.conversation(model.conversation);
        }

        public final ConversationSource.Builder getConversation() {
            return this.conversation != null ? this.conversation.toBuilder() : null;
        }

        public final void setConversation(ConversationSource.BuilderImpl conversation) {
            ConversationSource oldValue = this.conversation;
            this.conversation = conversation != null ? conversation.build() : null;
            this.handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
        }

        @Override
        public final Builder conversation(ConversationSource conversation) {
            ConversationSource oldValue = this.conversation;
            this.conversation = conversation;
            this.handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
            return this;
        }

        public CopyFromSource build() {
            return new CopyFromSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyFromSource> {
        public Builder conversation(ConversationSource var1);

        default public Builder conversation(Consumer<ConversationSource.Builder> conversation) {
            return this.conversation((ConversationSource)((ConversationSource.Builder)ConversationSource.builder().applyMutation(conversation)).build());
        }
    }
}

